/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer;

import java.time.Duration;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.BatchPolicy;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.ConsumerPolicyBuilder;

public class ConsumerPolicy {
    public static final String DEFAULT_NAME = "default";
    public static final RetryPolicy NO_RETRY = new RetryPolicy().withMaxRetries(0);
    public static final ConsumerPolicy BOUNDED = ConsumerPolicy.builder().waitMessageTimeout(Duration.ofSeconds(5L)).continueOnFailure(false).build();
    public static final ConsumerPolicy BOUNDED_RETRY = ConsumerPolicy.builder().waitMessageTimeout(Duration.ofSeconds(5L)).retryPolicy(new RetryPolicy().withMaxRetries(3)).continueOnFailure(false).build();
    public static final ConsumerPolicy UNBOUNDED = ConsumerPolicy.builder().continueOnFailure(true).waitMessageForEver().build();
    public static final ConsumerPolicy UNBOUNDED_RETRY = ConsumerPolicy.builder().continueOnFailure(true).retryPolicy(new RetryPolicy().withMaxRetries(3)).waitMessageForEver().build();
    private final BatchPolicy batchPolicy;
    private final RetryPolicy retryPolicy;
    private final boolean skipFailure;
    private final Duration waitMessageTimeout;
    private final StartOffset startOffset;
    private final boolean salted;
    private final String name;
    private final short maxThreads;

    public ConsumerPolicy(ConsumerPolicyBuilder builder) {
        this.batchPolicy = builder.batchPolicy;
        this.retryPolicy = builder.retryPolicy;
        this.skipFailure = builder.skipFailure;
        this.waitMessageTimeout = builder.waitMessageTimeout;
        this.startOffset = builder.startOffset;
        this.salted = builder.salted;
        this.maxThreads = builder.maxThreads;
        this.name = builder.name != null ? builder.name : DEFAULT_NAME;
    }

    public BatchPolicy getBatchPolicy() {
        return this.batchPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public boolean continueOnFailure() {
        return this.skipFailure;
    }

    public Duration getWaitMessageTimeout() {
        return this.waitMessageTimeout;
    }

    public StartOffset getStartOffset() {
        return this.startOffset;
    }

    public boolean isSalted() {
        return this.salted;
    }

    public String getName() {
        return this.name;
    }

    public short getMaxThreads() {
        return this.maxThreads;
    }

    public static ConsumerPolicyBuilder builder() {
        return new ConsumerPolicyBuilder();
    }

    public String toString() {
        return "ConsumerPolicy{batchPolicy=" + this.batchPolicy + ", retryPolicy=" + this.retryPolicy + ", skipFailure=" + this.skipFailure + ", waitMessageTimeout=" + this.waitMessageTimeout + ", startOffset=" + (Object)((Object)this.startOffset) + ", salted=" + this.salted + ", name='" + this.name + '\'' + ", maxThreads=" + this.maxThreads + '}';
    }

    public static enum StartOffset {
        BEGIN,
        END,
        LAST_COMMITTED;

    }
}

