/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.mqueues.kafka;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Bytes;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQAppender;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQOffset;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.internals.MQOffsetImpl;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.kafka.KafkaMQTailer;

public class KafkaMQAppender<M extends Externalizable>
implements MQAppender<M> {
    private static final Log log = LogFactory.getLog(KafkaMQAppender.class);
    private final String topic;
    private final Properties consumerProps;
    private final Properties producerProps;
    private final int size;
    private KafkaProducer<String, Bytes> producer;
    private final ConcurrentLinkedQueue<KafkaMQTailer<M>> tailers = new ConcurrentLinkedQueue();
    private final String name;
    private boolean closed;

    public static <M extends Externalizable> KafkaMQAppender<M> open(String topic, String name, Properties producerProperties, Properties consumerProperties) {
        return new KafkaMQAppender<M>(topic, name, producerProperties, consumerProperties);
    }

    private KafkaMQAppender(String topic, String name, Properties producerProperties, Properties consumerProperties) {
        this.topic = topic;
        this.name = name;
        this.producerProps = producerProperties;
        this.consumerProps = consumerProperties;
        this.producer = new KafkaProducer(this.producerProps);
        this.size = this.producer.partitionsFor(topic).size();
        log.debug((Object)String.format("Created appender: %s on topic: %s with %d partitions", name, topic, this.size));
    }

    @Override
    public String name() {
        return this.name;
    }

    public String getTopic() {
        return this.topic;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public MQOffset append(int partition, Externalizable message) {
        RecordMetadata result;
        Bytes value = Bytes.wrap((byte[])this.messageAsByteArray(message));
        String key = String.valueOf(partition);
        ProducerRecord record = new ProducerRecord(this.topic, Integer.valueOf(partition), (Object)key, (Object)value);
        Future future = this.producer.send(record);
        try {
            result = (RecordMetadata)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Unable to send record: " + record, e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unable to send record: " + record, e);
        }
        MQOffsetImpl ret = new MQOffsetImpl(this.name, partition, result.offset());
        if (log.isDebugEnabled()) {
            int len = ((Bytes)record.value()).get().length;
            log.debug((Object)String.format("append to %s-%02d:+%d, len: %d, key: %s, value: %s", this.name, partition, ret.offset(), len, key, message));
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] messageAsByteArray(Externalizable message) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(message);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(MQOffset offset, String group, Duration timeout) throws InterruptedException {
        boolean ret = false;
        if (!this.name.equals(offset.partition().name())) {
            throw new IllegalArgumentException(this.name + " can not wait for an offset of a different MQueue: " + offset);
        }
        TopicPartition topicPartition = new TopicPartition(this.topic, offset.partition().partition());
        try {
            ret = this.isProcessed(group, topicPartition, offset.offset());
            if (ret) {
                boolean bl = true;
                return bl;
            }
            long timeoutMs = timeout.toMillis();
            long deadline = System.currentTimeMillis() + timeoutMs;
            long delay = Math.min(100L, timeoutMs);
            while (!ret && System.currentTimeMillis() < deadline) {
                Thread.sleep(delay);
                ret = this.isProcessed(group, topicPartition, offset.offset());
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("waitFor " + offset + "/" + group + " returns: " + ret));
            }
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProcessed(String group, TopicPartition topicPartition, long offset) {
        Properties props = (Properties)this.consumerProps.clone();
        props.put("group.id", group);
        consumer.assign(Collections.singletonList(topicPartition));
        try (KafkaConsumer consumer = new KafkaConsumer(props);){
            boolean ret;
            long last = consumer.position(topicPartition);
            boolean bl = ret = last > 0L && last > offset;
            if (log.isDebugEnabled()) {
                log.debug((Object)("isProcessed " + topicPartition.topic() + ":" + topicPartition.partition() + "/" + group + ":+" + offset + "? " + ret + ", current position: " + last));
            }
            boolean bl2 = ret;
            return bl2;
        }
    }

    @Override
    public void close() throws Exception {
        log.debug((Object)("Closing appender: " + this.name));
        this.tailers.stream().filter(Objects::nonNull).forEach(tailer -> {
            try {
                tailer.close();
            }
            catch (Exception e) {
                log.error((Object)("Failed to close tailer: " + tailer));
            }
        });
        this.tailers.clear();
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
        this.closed = true;
    }
}

