/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.mqueues.internals;

import java.io.Externalizable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQAppender;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQManager;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQPartition;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQRebalanceListener;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQTailer;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.internals.MQPartitionGroup;

public abstract class AbstractMQManager<M extends Externalizable>
implements MQManager<M> {
    private final Map<String, MQAppender<M>> appenders = new ConcurrentHashMap<String, MQAppender<M>>();
    private final Map<MQPartitionGroup, MQTailer<M>> tailersAssignments = new ConcurrentHashMap<MQPartitionGroup, MQTailer<M>>();
    private final Set<MQTailer<M>> tailers = Collections.newSetFromMap(new ConcurrentHashMap());

    protected abstract void create(String var1, int var2);

    protected abstract MQAppender<M> createAppender(String var1);

    protected abstract MQTailer<M> acquireTailer(Collection<MQPartition> var1, String var2);

    protected abstract MQTailer<M> doSubscribe(String var1, Collection<String> var2, MQRebalanceListener var3);

    @Override
    public boolean createIfNotExists(String name, int size) {
        if (!this.exists(name)) {
            this.create(name, size);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(String name) {
        return false;
    }

    @Override
    public MQTailer<M> createTailer(String group, Collection<MQPartition> partitions) {
        partitions.forEach(partition -> this.checkTailerForPartition(group, (MQPartition)partition));
        MQTailer<M> ret = this.acquireTailer(partitions, group);
        partitions.forEach(partition -> this.tailersAssignments.put(new MQPartitionGroup(group, (MQPartition)partition), ret));
        this.tailers.add(ret);
        return ret;
    }

    @Override
    public boolean supportSubscribe() {
        return false;
    }

    @Override
    public MQTailer<M> subscribe(String group, Collection<String> names, MQRebalanceListener listener) {
        MQTailer<M> ret = this.doSubscribe(group, names, listener);
        this.tailers.add(ret);
        return ret;
    }

    private void checkTailerForPartition(String group, MQPartition partition) {
        MQPartitionGroup key = new MQPartitionGroup(group, partition);
        MQTailer<M> ret = this.tailersAssignments.get(key);
        if (ret != null && !ret.closed()) {
            throw new IllegalArgumentException("Tailer for this partition already created: " + partition + ", group: " + group);
        }
        if (!this.exists(partition.name())) {
            throw new IllegalArgumentException("Tailer with unknown MQueue name: " + partition.name());
        }
    }

    @Override
    public MQTailer<M> createTailer(String group, MQPartition partition) {
        return this.createTailer(group, Collections.singletonList(partition));
    }

    @Override
    public synchronized MQAppender<M> getAppender(String name) {
        if (!this.appenders.containsKey(name) || this.appenders.get(name).closed()) {
            if (this.exists(name)) {
                this.appenders.put(name, this.createAppender(name));
            } else {
                throw new IllegalArgumentException("unknown MQueue name: " + name);
            }
        }
        return this.appenders.get(name);
    }

    @Override
    public void close() throws Exception {
        for (MQAppender<M> mQAppender : this.appenders.values()) {
            mQAppender.close();
        }
        this.appenders.clear();
        for (MQTailer mQTailer : this.tailers) {
            mQTailer.close();
        }
        this.tailers.clear();
        this.tailersAssignments.clear();
    }
}

