/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.mqueues.chronicle;

import java.io.File;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;

public class ChronicleMQOffsetTracker
implements AutoCloseable {
    private final SingleChronicleQueue offsetQueue;
    private final int queueIndex;
    private static final String OFFSET_QUEUE_PREFIX = "offset-";
    private long lastCommittedOffset;

    public ChronicleMQOffsetTracker(String basePath, int queue, String group) {
        this.queueIndex = queue;
        File offsetFile = new File(basePath, OFFSET_QUEUE_PREFIX + group);
        this.offsetQueue = SingleChronicleQueueBuilder.binary((File)offsetFile).build();
    }

    public long getLastCommittedOffset() {
        if (this.lastCommittedOffset > 0L) {
            return this.lastCommittedOffset;
        }
        return this.readLastCommittedOffset();
    }

    public long readLastCommittedOffset() {
        boolean hasNext;
        ExcerptTailer offsetTailer = this.offsetQueue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
        long[] offset = new long[]{0L};
        do {
            hasNext = offsetTailer.readBytes(b -> {
                int queue = b.readInt();
                long off = b.readLong();
                long stamp = b.readLong();
                if (this.queueIndex == queue) {
                    offset[0] = off;
                }
            });
        } while (offset[0] == 0L && hasNext);
        return offset[0];
    }

    public void commit(long offset) {
        this.offsetQueue.acquireAppender().writeBytes(b -> b.writeInt(this.queueIndex).writeLong(offset).writeLong(System.currentTimeMillis()));
        this.lastCommittedOffset = offset;
    }

    @Override
    public void close() {
        this.offsetQueue.close();
    }
}

