/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.executor;

import org.apache.commons.logging.Log;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.factories.DefaultDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.log.BasicLogger;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.threading.DefaultMultiThreadingPolicy;
import org.nuxeo.ecm.platform.importer.threading.ImporterThreadingPolicy;

public abstract class AbstractImporterExecutor {
    protected static ImporterLogger log;
    protected static Thread executorMainThread;
    protected static ImporterRunner lastRunner;
    protected ImporterThreadingPolicy threadPolicy;
    protected ImporterDocumentModelFactory factory;
    protected int transactionTimeout = 0;

    protected abstract Log getJavaLogger();

    public ImporterLogger getLogger() {
        if (log == null) {
            log = new BasicLogger(this.getJavaLogger());
        }
        return log;
    }

    public String getStatus() {
        if (this.isRunning()) {
            return "Running";
        }
        return "Not Running";
    }

    public boolean isRunning() {
        if (executorMainThread == null) {
            return false;
        }
        return executorMainThread.isAlive();
    }

    public String kill() {
        if (executorMainThread != null) {
            if (lastRunner != null) {
                lastRunner.stopImportProcrocess();
            }
            executorMainThread.interrupt();
            return "Importer killed";
        }
        return "Importer is not running";
    }

    protected void startTask(ImporterRunner runner, boolean interactive) {
        executorMainThread = new Thread(runner);
        executorMainThread.setName("ImporterExecutorMainThread");
        if (interactive) {
            executorMainThread.run();
        } else {
            executorMainThread.start();
        }
    }

    protected String doRun(ImporterRunner runner, Boolean interactive) {
        if (this.isRunning()) {
            throw new NuxeoException("Task is already running");
        }
        if (interactive == null) {
            interactive = false;
        }
        lastRunner = runner;
        this.startTask(runner, interactive);
        if (interactive.booleanValue()) {
            return "Task compeleted";
        }
        return "Started";
    }

    public ImporterThreadingPolicy getThreadPolicy() {
        if (this.threadPolicy == null) {
            this.threadPolicy = new DefaultMultiThreadingPolicy();
        }
        return this.threadPolicy;
    }

    public void setThreadPolicy(ImporterThreadingPolicy threadPolicy) {
        this.threadPolicy = threadPolicy;
    }

    public ImporterDocumentModelFactory getFactory() {
        if (this.factory == null) {
            this.factory = new DefaultDocumentModelFactory();
        }
        return this.factory;
    }

    public void setFactory(ImporterDocumentModelFactory factory) {
        this.factory = factory;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public String run(ImporterRunner runner, Boolean interactive) {
        return this.doRun(runner, interactive);
    }
}

