/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.runtime.api.Framework;

public class FulltextParser {
    protected static final String WORD_SPLIT_PROP = "org.nuxeo.vcs.fulltext.wordsplit";
    protected static final String WORD_SPLIT_DEF = "[\\s\\p{Punct}]+";
    protected static final Pattern WORD_SPLIT_PATTERN = Pattern.compile(Framework.getProperty((String)"org.nuxeo.vcs.fulltext.wordsplit", (String)"[\\s\\p{Punct}]+"));
    protected DBSDocumentState document;
    protected DBSSession session;
    protected String documentType;
    protected Object[] mixinTypes;
    protected String indexName;
    protected Set<String> paths;
    protected ArrayList<String> strings;

    public ArrayList<String> getStrings() {
        return this.strings;
    }

    public void setStrings(ArrayList<String> strings) {
        this.strings = strings;
    }

    protected void setDocument(DBSDocumentState document, DBSSession session) {
        this.document = document;
        this.session = session;
        if (document != null) {
            this.documentType = document.getPrimaryType();
            this.mixinTypes = (Object[])document.get("ecm:mixinTypes");
        }
    }

    public String findFulltext(String indexName) {
        this.indexName = indexName;
        this.strings = new ArrayList();
        State state = this.document.getState();
        this.findFulltext(indexName, state);
        return StringUtils.join(this.strings, (char)' ');
    }

    protected void findFulltext(String indexName, State state) {
        block6: for (Map.Entry en : state.entrySet()) {
            Serializable value;
            String key = (String)en.getKey();
            if (key.startsWith("ecm:")) {
                switch (key) {
                    case "ecm:name": {
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            if ((value = (Serializable)en.getValue()) instanceof State) {
                State s = (State)value;
                this.findFulltext(indexName, s);
                continue;
            }
            if (value instanceof List) {
                List v = (List)((Object)value);
                for (State s : v) {
                    this.findFulltext(indexName, s);
                }
                continue;
            }
            if (value instanceof Object[]) {
                Object[] ar;
                for (Object v : ar = (Object[])value) {
                    if (!(v instanceof String)) break;
                    this.parse((String)v, null);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            this.parse((String)((Object)value), null);
        }
    }

    public void parse(String s, String path) {
        s = this.preprocessField(s, path);
        for (String word : WORD_SPLIT_PATTERN.split(s)) {
            if (word.isEmpty()) continue;
            this.strings.add(word.toLowerCase());
        }
    }

    protected String preprocessField(String s, String path) {
        if (s == null) {
            return null;
        }
        if (s.contains("<")) {
            s = this.removeHtml(s);
        }
        return StringEscapeUtils.unescapeHtml((String)s);
    }

    protected String removeHtml(String s) {
        Source source = new Source((CharSequence)s);
        Renderer renderer = source.getRenderer();
        renderer.setIncludeHyperlinkURLs(false);
        renderer.setDecorateFontStyles(false);
        return renderer.toString();
    }
}

