/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.runtime.api.Framework;

public class DBSExpressionEvaluator
extends ExpressionEvaluator {
    private static final Log log = LogFactory.getLog(DBSExpressionEvaluator.class);
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;
    protected final Expression expr;
    protected final SchemaManager schemaManager;
    protected State state;

    public DBSExpressionEvaluator(DBSSession session, Expression expr, String[] principals) {
        super((ExpressionEvaluator.PathResolver)new DBSPathResolver(session), principals);
        this.expr = expr;
        this.schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
    }

    public boolean matches(State state) {
        this.state = state;
        if (this.principals != null) {
            String[] racl = (String[])this.walkReference(new Reference("ecm:__read_acl"));
            if (racl == null) {
                log.error((Object)("NULL racl for " + state.get((Object)"ecm:id")));
            } else {
                boolean allowed = false;
                for (String user : racl) {
                    if (!this.principals.contains(user)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    return false;
                }
            }
        }
        return Boolean.TRUE.equals(this.walkExpression(this.expr));
    }

    public boolean matches(DBSDocumentState docState) {
        return this.matches(docState.getState());
    }

    public Object walkReference(Reference ref) {
        return this.evaluateReference(ref, this.state);
    }

    public Object evaluateReference(Reference ref, State state) {
        boolean isTrueOrNullBoolean;
        boolean isBoolean;
        boolean isArray;
        String name = ref.name;
        String[] split = name.split("/");
        String prop = split[0];
        if (name.startsWith("ecm:")) {
            prop = DBSSession.convToInternal(name);
            isArray = DBSSession.isArray(prop);
            isBoolean = DBSSession.isBoolean(prop);
            isTrueOrNullBoolean = true;
        } else {
            Field field = this.schemaManager.getField(prop);
            if (field == null) {
                if (prop.indexOf(58) > -1) {
                    throw new RuntimeException("Unkown property: " + name);
                }
                for (Schema schema : this.schemaManager.getSchemas()) {
                    if (StringUtils.isBlank((String)schema.getNamespace().prefix) && schema != null && (field = schema.getField(prop)) != null) break;
                }
                if (field == null) {
                    throw new RuntimeException("Unkown property: " + name);
                }
            }
            prop = field.getName().getPrefixedName();
            Type type = field.getType();
            isArray = type instanceof ListType && ((ListType)type).isArray();
            isBoolean = type instanceof BooleanType;
            isTrueOrNullBoolean = false;
        }
        Object value = (Object[])state.get((Object)prop);
        for (int i = 1; i < split.length; ++i) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof State)) {
                throw new RuntimeException("Unkown property (no State): " + name);
            }
            value = (Serializable)((State)value).get((Object)split[i]);
        }
        if (value == null && isArray) {
            value = new Object[]{};
        }
        if (isBoolean) {
            value = isTrueOrNullBoolean ? (Boolean.TRUE.equals(value) ? ONE : ZERO) : (value == null ? null : ((Boolean)value != false ? ONE : ZERO));
        }
        return value;
    }

    public static class OrderByComparator
    implements Comparator<State> {
        protected final OrderByClause orderByClause;
        protected ExpressionEvaluator matcher;

        public OrderByComparator(OrderByClause orderByClause, ExpressionEvaluator matcher) {
            OrderByList obl = new OrderByList(null);
            obl.clear();
            for (OrderByExpr ob : orderByClause.elements) {
                if (ob.reference.name.equals("ecm:path")) {
                    ob = new OrderByExpr(new Reference("ecm:__path"), ob.isDescending);
                }
                obl.add((Object)ob);
            }
            this.orderByClause = new OrderByClause(obl);
            this.matcher = matcher;
        }

        @Override
        public int compare(State s1, State s2) {
            Iterator i$ = this.orderByClause.elements.iterator();
            if (i$.hasNext()) {
                OrderByExpr ob = (OrderByExpr)i$.next();
                Reference ref = ob.reference;
                boolean desc = ob.isDescending;
                int sign = desc ? -1 : 1;
                Object v1 = this.matcher.evaluateReference(ref, s1);
                Object v2 = this.matcher.evaluateReference(ref, s2);
                if (v1 == null) {
                    return v2 == null ? 0 : -sign;
                }
                if (v2 == null) {
                    return sign;
                }
                if (!(v1 instanceof Comparable)) {
                    throw new RuntimeException("Not a comparable: " + v1);
                }
                int cmp = ((Comparable)v1).compareTo(v2);
                return desc ? -cmp : cmp;
            }
            return 0;
        }
    }

    protected static class DBSPathResolver
    implements ExpressionEvaluator.PathResolver {
        protected final DBSSession session;

        public DBSPathResolver(DBSSession session) {
            this.session = session;
        }

        public String getIdForPath(String path) {
            return this.session.getDocumentIdByPath(path);
        }
    }
}

