/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nuxeo.ecm.core.storage.CopyHelper;
import org.nuxeo.ecm.core.storage.State;

public class DBSDocumentState {
    protected State state;
    protected AtomicBoolean dirty = new AtomicBoolean(false);
    protected boolean dirtyFulltext;

    public DBSDocumentState() {
        this.state = new State();
    }

    public DBSDocumentState(State base) {
        this.state = CopyHelper.deepCopy((State)base);
    }

    public DBSDocumentState(DBSDocumentState docState) {
        this(docState.state);
    }

    public AtomicBoolean getDirty() {
        return this.dirty;
    }

    public boolean isDirty() {
        return this.dirty.get() || this.dirtyFulltext;
    }

    public boolean isDirtyIgnoringFulltext() {
        return this.dirty.get();
    }

    public void setNotDirty() {
        this.dirty.set(false);
        this.dirtyFulltext = false;
    }

    public State getState() {
        return this.state;
    }

    public Serializable get(String key) {
        return (Serializable)this.state.get((Object)key);
    }

    public void put(String key, Serializable value) {
        this.state.put((Object)key, (Object)value);
        switch (key) {
            case "ecm:fulltextSimple": 
            case "ecm:fulltextBinary": 
            case "ecm:fulltextJobId": {
                this.dirtyFulltext = true;
                break;
            }
            default: {
                this.dirty.set(true);
            }
        }
    }

    public boolean containsKey(String key) {
        return this.state.get((Object)key) != null;
    }

    public String getId() {
        return (String)((Object)this.get("ecm:id"));
    }

    public String getParentId() {
        return (String)((Object)this.get("ecm:parentId"));
    }

    public String getName() {
        return (String)((Object)this.get("ecm:name"));
    }

    public String getPrimaryType() {
        return (String)((Object)this.get("ecm:primaryType"));
    }

    public String getVersionSeriesId() {
        return (String)((Object)this.get("ecm:versionSeriesId"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(dirty=" + this.dirty + ',' + this.state.toString() + ')';
    }
}

