/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StorageBlob;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerStreamSupport;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.sql.LockManager;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersion;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class DBSDocument
implements Document {
    private static final Long ZERO = 0L;
    public static final String SYSPROP_FULLTEXT_SIMPLE = "fulltextSimple";
    public static final String SYSPROP_FULLTEXT_BINARY = "fulltextBinary";
    public static final String SYSPROP_FULLTEXT_JOBID = "fulltextJobId";
    public static final String KEY_PREFIX = "ecm:";
    public static final String KEY_ID = "ecm:id";
    public static final String KEY_PARENT_ID = "ecm:parentId";
    public static final String KEY_ANCESTOR_IDS = "ecm:ancestorIds";
    public static final String KEY_PRIMARY_TYPE = "ecm:primaryType";
    public static final String KEY_MIXIN_TYPES = "ecm:mixinTypes";
    public static final String KEY_NAME = "ecm:name";
    public static final String KEY_POS = "ecm:pos";
    public static final String KEY_ACP = "ecm:acp";
    public static final String KEY_ACL_NAME = "name";
    public static final String KEY_PATH_INTERNAL = "ecm:__path";
    public static final String KEY_ACL = "acl";
    public static final String KEY_ACE_USER = "user";
    public static final String KEY_ACE_PERMISSION = "perm";
    public static final String KEY_ACE_GRANT = "grant";
    public static final String KEY_READ_ACL = "ecm:racl";
    public static final String KEY_IS_CHECKED_IN = "ecm:isCheckedIn";
    public static final String KEY_IS_VERSION = "ecm:isVersion";
    public static final String KEY_IS_LATEST_VERSION = "ecm:isLatestVersion";
    public static final String KEY_IS_LATEST_MAJOR_VERSION = "ecm:isLatestMajorVersion";
    public static final String KEY_MAJOR_VERSION = "ecm:majorVersion";
    public static final String KEY_MINOR_VERSION = "ecm:minorVersion";
    public static final String KEY_VERSION_SERIES_ID = "ecm:versionSeriesId";
    public static final String KEY_VERSION_CREATED = "ecm:versionCreated";
    public static final String KEY_VERSION_LABEL = "ecm:versionLabel";
    public static final String KEY_VERSION_DESCRIPTION = "ecm:versionDescription";
    public static final String KEY_BASE_VERSION_ID = "ecm:baseVersionId";
    public static final String KEY_IS_PROXY = "ecm:isProxy";
    public static final String KEY_PROXY_TARGET_ID = "ecm:proxyTargetId";
    public static final String KEY_PROXY_VERSION_SERIES_ID = "ecm:proxyVersionSeriesId";
    public static final String KEY_PROXY_IDS = "ecm:proxyIds";
    public static final String KEY_LIFECYCLE_POLICY = "ecm:lifeCyclePolicy";
    public static final String KEY_LIFECYCLE_STATE = "ecm:lifeCycleState";
    public static final String KEY_LOCK_OWNER = "ecm:lockOwner";
    public static final String KEY_LOCK_CREATED = "ecm:lockCreated";
    public static final String KEY_BLOB_NAME = "name";
    public static final String KEY_BLOB_MIME_TYPE = "mime-type";
    public static final String KEY_BLOB_ENCODING = "encoding";
    public static final String KEY_BLOB_DIGEST = "digest";
    public static final String KEY_BLOB_LENGTH = "length";
    public static final String KEY_BLOB_DATA = "data";
    public static final String KEY_FULLTEXT_SIMPLE = "ecm:fulltextSimple";
    public static final String KEY_FULLTEXT_BINARY = "ecm:fulltextBinary";
    public static final String KEY_FULLTEXT_JOBID = "ecm:fulltextJobId";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected final String id;
    protected final DBSDocumentState docState;
    protected final DocumentType type;
    protected final DBSSession session;
    protected boolean readonly;

    public DBSDocument(DBSDocumentState docState, DocumentType type, DBSSession session, boolean readonly) {
        this.id = docState == null ? null : (String)((Object)docState.get(KEY_ID));
        this.docState = docState;
        this.type = type;
        this.session = session;
        this.readonly = readonly;
    }

    public DocumentType getType() {
        return this.type;
    }

    public Session getSession() {
        return this.session;
    }

    public String getRepositoryName() {
        return this.session.getRepositoryName();
    }

    public String getUUID() {
        return this.id;
    }

    public String getName() {
        return this.docState.getName();
    }

    public Document getParent() throws DocumentException {
        String parentId = this.docState.getParentId();
        return parentId == null ? null : this.session.getDocument(parentId);
    }

    public boolean isProxy() {
        return Boolean.TRUE.equals(this.docState.get(KEY_IS_PROXY));
    }

    public boolean isVersion() {
        return Boolean.TRUE.equals(this.docState.get(KEY_IS_VERSION));
    }

    public String getPath() throws DocumentException {
        String name = this.getName();
        Document doc = this.getParent();
        if (doc == null) {
            if ("".equals(name)) {
                return "/";
            }
            return name;
        }
        LinkedList<String> list = new LinkedList<String>();
        list.addFirst(name);
        while (doc != null) {
            list.addFirst(doc.getName());
            doc = doc.getParent();
        }
        return StringUtils.join(list, (char)'/');
    }

    public Document getChild(String name) throws DocumentException {
        return this.session.getChild(this.id, name);
    }

    public Iterator<Document> getChildren() throws DocumentException {
        if (!this.isFolder()) {
            return EmptyDocumentIterator.INSTANCE;
        }
        return this.session.getChildren(this.id);
    }

    public List<String> getChildrenIds() throws DocumentException {
        if (!this.isFolder()) {
            return Collections.emptyList();
        }
        return this.session.getChildrenIds(this.id);
    }

    public boolean hasChild(String name) throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChild(this.id, name);
    }

    public boolean hasChildren() throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChildren(this.id);
    }

    public Document addChild(String name, String typeName) throws DocumentException {
        if (!this.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        return this.session.createChild(null, this.id, name, null, typeName);
    }

    public void orderBefore(String src, String dest) throws DocumentException {
        Document destDoc;
        Document srcDoc = this.getChild(src);
        if (srcDoc == null) {
            throw new DocumentException("Document " + this + " has no child: " + src);
        }
        if (dest == null) {
            destDoc = null;
        } else {
            destDoc = this.getChild(dest);
            if (destDoc == null) {
                throw new DocumentException("Document " + this + " has no child: " + dest);
            }
        }
        this.session.orderBefore(this.id, srcDoc.getUUID(), destDoc == null ? null : destDoc.getUUID());
    }

    public Serializable getPropertyValue(String name) throws DocumentException {
        DBSDocumentState docState = this.getStateMaybeProxyTarget(name);
        return docState.get(name);
    }

    public void setPropertyValue(String name, Serializable value) throws DocumentException {
        DBSDocumentState docState = this.getStateMaybeProxyTarget(name);
        docState.put(name, value);
    }

    public Document checkIn(String label, String checkinComment) throws DocumentException {
        if (this.isProxy()) {
            throw new DocumentException("Proxies cannot be checked in");
        }
        if (this.isVersion()) {
            throw new SQLDocumentVersion.VersionNotModifiableException();
        }
        return this.session.checkIn(this.id, label, checkinComment);
    }

    public void checkOut() throws DocumentException {
        if (this.isProxy()) {
            throw new DocumentException("Proxies cannot be checked out");
        }
        if (this.isVersion()) {
            throw new SQLDocumentVersion.VersionNotModifiableException();
        }
        this.session.checkOut(this.id);
    }

    public List<String> getVersionsIds() throws DocumentException {
        return this.session.getVersionsIds(this.getVersionSeriesId());
    }

    public List<Document> getVersions() throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Document getLastVersion() throws DocumentException {
        return this.session.getLastVersion(this.getVersionSeriesId());
    }

    public Document getSourceDocument() throws DocumentException {
        if (this.isProxy()) {
            return this.getTargetDocument();
        }
        if (this.isVersion()) {
            return this.getWorkingCopy();
        }
        return this;
    }

    public void restore(Document version) throws DocumentException {
        if (!version.isVersion()) {
            throw new DocumentException("Cannot restore a non-version: " + version);
        }
        this.session.restoreVersion(this, version);
    }

    public Document getVersion(String label) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Document getBaseVersion() throws DocumentException {
        if (this.isProxy() || this.isVersion()) {
            return null;
        }
        if (this.isCheckedOut()) {
            return null;
        }
        String id = (String)((Object)this.docState.get(KEY_BASE_VERSION_ID));
        if (id == null) {
            return null;
        }
        return this.session.getDocument(id);
    }

    public boolean isCheckedOut() throws DocumentException {
        if (this.isVersion()) {
            return false;
        }
        return !Boolean.TRUE.equals(this.docState.get(KEY_IS_CHECKED_IN));
    }

    public String getVersionSeriesId() throws DocumentException {
        if (this.isProxy()) {
            return (String)((Object)this.docState.get(KEY_PROXY_VERSION_SERIES_ID));
        }
        if (this.isVersion()) {
            return (String)((Object)this.docState.get(KEY_VERSION_SERIES_ID));
        }
        return this.getUUID();
    }

    public Calendar getVersionCreationDate() throws DocumentException {
        return (Calendar)this.docState.get(KEY_VERSION_CREATED);
    }

    public String getVersionLabel() throws DocumentException {
        return (String)((Object)this.docState.get(KEY_VERSION_LABEL));
    }

    public String getCheckinComment() throws DocumentException {
        return (String)((Object)this.docState.get(KEY_VERSION_DESCRIPTION));
    }

    public boolean isLatestVersion() throws DocumentException {
        if (this.isProxy() || this.isVersion()) {
            return Boolean.TRUE.equals(this.docState.get(KEY_IS_LATEST_VERSION));
        }
        return false;
    }

    public boolean isMajorVersion() throws DocumentException {
        if (this.isProxy() || this.isVersion()) {
            return ZERO.equals(this.docState.get(KEY_MINOR_VERSION));
        }
        return false;
    }

    public boolean isLatestMajorVersion() throws DocumentException {
        if (this.isProxy() || this.isVersion()) {
            return Boolean.TRUE.equals(this.docState.get(KEY_IS_LATEST_MAJOR_VERSION));
        }
        return false;
    }

    public boolean isVersionSeriesCheckedOut() throws DocumentException {
        if (this.isProxy() || this.isVersion()) {
            Document workingCopy = this.getWorkingCopy();
            return workingCopy == null ? false : workingCopy.isCheckedOut();
        }
        return this.isCheckedOut();
    }

    public Document getWorkingCopy() throws DocumentException {
        if (this.isProxy() || this.isVersion()) {
            String versionSeriesId = this.getVersionSeriesId();
            return versionSeriesId == null ? null : this.session.getDocument(versionSeriesId);
        }
        return this;
    }

    public Lock setLock(Lock lock) throws DocumentException {
        Lock oldLock = this.getLock();
        if (oldLock == null) {
            this.docState.put(KEY_LOCK_OWNER, (Serializable)((Object)lock.getOwner()));
            this.docState.put(KEY_LOCK_CREATED, lock.getCreated());
        }
        return oldLock;
    }

    public Lock removeLock(String owner) throws DocumentException {
        Lock oldLock = this.getLock();
        if (owner != null) {
            if (oldLock != null && !LockManager.canLockBeRemoved((Lock)oldLock, (String)owner)) {
                return new Lock(oldLock, true);
            }
        } else if (oldLock != null) {
            this.docState.put(KEY_LOCK_OWNER, null);
            this.docState.put(KEY_LOCK_CREATED, null);
        }
        return oldLock;
    }

    public Lock getLock() throws DocumentException {
        String owner = (String)((Object)this.docState.get(KEY_LOCK_OWNER));
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)this.docState.get(KEY_LOCK_CREATED);
        return new Lock(owner, created);
    }

    public boolean isFolder() {
        return this.type == null || this.type.isFolder();
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void remove() throws DocumentException {
        this.session.remove(this.id);
    }

    public String getLifeCycleState() throws LifeCycleException {
        return (String)((Object)this.docState.get(KEY_LIFECYCLE_STATE));
    }

    public void setCurrentLifeCycleState(String lifeCycleState) throws LifeCycleException {
        this.docState.put(KEY_LIFECYCLE_STATE, (Serializable)((Object)lifeCycleState));
    }

    public String getLifeCyclePolicy() throws LifeCycleException {
        return (String)((Object)this.docState.get(KEY_LIFECYCLE_POLICY));
    }

    public void setLifeCyclePolicy(String policy) throws LifeCycleException {
        this.docState.put(KEY_LIFECYCLE_POLICY, (Serializable)((Object)policy));
    }

    public void followTransition(String transition) throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        service.followTransition((Document)this, transition);
    }

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        LifeCycle lifeCycle = service.getLifeCycleFor((Document)this);
        if (lifeCycle == null) {
            return Collections.emptyList();
        }
        return lifeCycle.getAllowedStateTransitionsFrom(this.getLifeCycleState());
    }

    public void setSystemProp(String name, Serializable value) throws DocumentException {
        String propertyName;
        if (name.equals(SYSPROP_FULLTEXT_SIMPLE)) {
            propertyName = KEY_FULLTEXT_SIMPLE;
        } else if (name.equals(SYSPROP_FULLTEXT_BINARY)) {
            propertyName = KEY_FULLTEXT_BINARY;
        } else if (name.equals(SYSPROP_FULLTEXT_JOBID)) {
            propertyName = KEY_FULLTEXT_JOBID;
        } else {
            throw new DocumentException("Unknown system property: " + name);
        }
        this.setPropertyValue(propertyName, value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    protected DBSDocumentState getStateMaybeProxyTarget(Type type) throws PropertyException {
        if (this.isProxy() && !this.isSchemaForProxy(type.getName())) {
            try {
                return ((DBSDocument)this.getTargetDocument()).docState;
            }
            catch (DocumentException e) {
                throw new PropertyException(e.getMessage(), (Throwable)e);
            }
        }
        return this.docState;
    }

    protected DBSDocumentState getStateMaybeProxyTarget(String xpath) throws DocumentException {
        if (this.isProxy() && !this.isSchemaForProxy(this.getSchema(xpath))) {
            return ((DBSDocument)this.getTargetDocument()).docState;
        }
        return this.docState;
    }

    protected boolean isSchemaForProxy(String schema) {
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        return schemaManager.isProxySchema(schema, this.getType().getName());
    }

    protected String getSchema(String xpath) throws DocumentException {
        int p = xpath.indexOf(58);
        if (p == -1) {
            throw new DocumentException("Schema not specified: " + xpath);
        }
        String prefix = xpath.substring(0, p);
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = schemaManager.getSchemaFromPrefix(prefix);
        if (schema == null && (schema = schemaManager.getSchema(prefix)) == null) {
            throw new DocumentException("No schema for prefix: " + xpath);
        }
        return schema.getName();
    }

    public void readDocumentPart(DocumentPart dp) throws PropertyException {
        DBSDocumentState docState = this.getStateMaybeProxyTarget(dp.getType());
        this.readComplexProperty((ComplexProperty)dp, docState.getState());
    }

    protected String internalName(String name) {
        switch (name) {
            case "major_version": {
                return KEY_MAJOR_VERSION;
            }
            case "minor_version": {
                return KEY_MINOR_VERSION;
            }
        }
        return name;
    }

    protected void readComplexProperty(ComplexProperty complexProperty, State state) throws PropertyException {
        if (state == null) {
            complexProperty.init(null);
            return;
        }
        if (complexProperty instanceof BlobProperty) {
            StorageBlob value = this.readBlob(state);
            complexProperty.init((Serializable)value);
            return;
        }
        for (Property property : complexProperty) {
            String name = property.getField().getName().getPrefixedName();
            name = this.internalName(name);
            Type type = property.getType();
            if (type.isSimpleType()) {
                Serializable value = (Serializable)state.get((Object)name);
                property.init(value);
                continue;
            }
            if (type.isListType()) {
                ListType listType = (ListType)type;
                if (listType.getFieldType().isSimpleType()) {
                    Object[] array = (Object[])state.get((Object)name);
                    array = DBSDocument.typedArray(listType.getFieldType(), array);
                    property.init((Serializable)array);
                    continue;
                }
                List list = (List)state.get((Object)name);
                if (list == null) {
                    property.init(null);
                    continue;
                }
                Field listField = listType.getField();
                ArrayList<Serializable> value = new ArrayList<Serializable>(list.size());
                for (Serializable subMapSer : list) {
                    State childMap = (State)subMapSer;
                    ComplexProperty p = (ComplexProperty)complexProperty.getRoot().createProperty(property, listField, 0);
                    this.readComplexProperty(p, childMap);
                    value.add(p.getValue());
                }
                property.init((Serializable)value);
                continue;
            }
            State childMap = (State)state.get((Object)name);
            this.readComplexProperty((ComplexProperty)property, childMap);
            ((ComplexProperty)property).removePhantomFlag();
        }
    }

    protected static Object[] typedArray(Type type, Object[] array) {
        Class klass;
        if (array == null) {
            return null;
        }
        if (type instanceof StringType) {
            klass = String.class;
        } else if (type instanceof BooleanType) {
            klass = Boolean.class;
        } else if (type instanceof LongType) {
            klass = Long.class;
        } else if (type instanceof DoubleType) {
            klass = Double.class;
        } else if (type instanceof DateType) {
            klass = Calendar.class;
        } else if (type instanceof BinaryType) {
            klass = Binary.class;
        } else {
            if (type instanceof IntegerType) {
                throw new RuntimeException("Unimplemented primitive type: " + type.getClass().getName());
            }
            if (type instanceof SimpleTypeImpl) {
                return DBSDocument.typedArray(type.getSuperType(), array);
            }
            throw new RuntimeException("Invalid primitive type: " + type.getClass().getName());
        }
        int len = array.length;
        Object[] copy = (Object[])Array.newInstance(klass, len);
        System.arraycopy(array, 0, copy, 0, len);
        return copy;
    }

    protected StorageBlob readBlob(State state) {
        Serializable data = (Serializable)state.get((Object)KEY_BLOB_DATA);
        if (data == null) {
            return null;
        }
        Binary binary = this.session.getBinaryManager().getBinary((String)((Object)data));
        if (binary == null) {
            return null;
        }
        String name = (String)state.get((Object)"name");
        String mimeType = (String)state.get((Object)KEY_BLOB_MIME_TYPE);
        String encoding = (String)state.get((Object)KEY_BLOB_ENCODING);
        String digest = (String)state.get((Object)KEY_BLOB_DIGEST);
        Long length = (Long)state.get((Object)KEY_BLOB_LENGTH);
        return new StorageBlob(binary, name, mimeType, encoding, digest, length.longValue());
    }

    protected void writeBlobProperty(BlobProperty blobProperty, State state) throws PropertyException {
        Long length;
        String digest;
        String encoding;
        String mimeType;
        String name;
        String data;
        Serializable value = blobProperty.getValueForWrite();
        if (value == null) {
            data = null;
            name = null;
            mimeType = null;
            encoding = null;
            digest = null;
            length = null;
        } else {
            Binary binary;
            if (!(value instanceof Blob)) {
                throw new PropertyException("Setting a non-Blob value: " + value);
            }
            Blob blob = (Blob)value;
            try {
                binary = this.getBinary(blob);
            }
            catch (DocumentException e) {
                throw new PropertyException("Cannot get binary", (Throwable)e);
            }
            data = binary.getDigest();
            name = blob.getFilename();
            mimeType = blob.getMimeType();
            if (mimeType == null) {
                mimeType = APPLICATION_OCTET_STREAM;
            }
            encoding = blob.getEncoding();
            digest = blob.getDigest();
            length = binary.getLength();
        }
        state.put((Object)KEY_BLOB_DATA, (Object)data);
        state.put((Object)"name", (Object)name);
        state.put((Object)KEY_BLOB_MIME_TYPE, (Object)mimeType);
        state.put((Object)KEY_BLOB_ENCODING, (Object)encoding);
        state.put((Object)KEY_BLOB_DIGEST, (Object)digest);
        state.put((Object)KEY_BLOB_LENGTH, (Object)length);
    }

    protected Binary getBinary(Blob blob) throws DocumentException {
        StreamingBlob sb;
        StreamSource source;
        if (blob instanceof StorageBlob) {
            return ((StorageBlob)blob).getBinary();
        }
        if (blob instanceof StreamingBlob && (source = (sb = (StreamingBlob)blob).getStreamSource()) instanceof FileSource && sb.isTemporary()) {
            return this.getBinary((FileSource)source);
        }
        try {
            InputStream stream = blob.getStream();
            return this.getBinary(stream);
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    protected Binary getBinary(FileSource source) throws DocumentException {
        BinaryManager binaryManager = this.session.getBinaryManager();
        try {
            if (binaryManager instanceof BinaryManagerStreamSupport) {
                return ((BinaryManagerStreamSupport)binaryManager).getBinary(source);
            }
            return binaryManager.getBinary(source.getStream());
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    protected Binary getBinary(InputStream in) throws DocumentException {
        BinaryManager repositoryManager = this.session.getBinaryManager();
        try {
            return repositoryManager.getBinary(in);
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    public Map<String, Serializable> readPrefetch(ComplexType complexType, Set<String> xpaths) throws PropertyException {
        DBSDocumentState docState = this.getStateMaybeProxyTarget((Type)complexType);
        HashMap<String, Serializable> prefetch = new HashMap<String, Serializable>();
        for (String xpath : xpaths) {
            try {
                DBSDocument.readPrefetch(complexType, docState.getState(), xpath, 0, prefetch);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage() + " xpath=" + xpath + ", data=" + docState, e);
            }
        }
        return prefetch;
    }

    protected static void readPrefetch(ComplexType type, State state, String xpath, int start, Map<String, Serializable> prefetch) {
        int i = xpath.indexOf(47, start);
        boolean last = i == -1;
        String prop = last ? xpath : xpath.substring(start, i);
        Object[] v = state == null ? null : (Object[])state.get((Object)prop);
        Field propType = type.getField(prop);
        if (last) {
            if (v instanceof State || v instanceof List) {
                throw new IllegalStateException("xpath=" + xpath + " start=" + start + " last element is not scalar");
            }
            if (v instanceof Object[]) {
                Type lt = ((ListType)propType.getType()).getFieldType();
                v = DBSDocument.typedArray(lt, v);
            }
            prefetch.put(xpath, (Serializable)v);
        } else {
            int len = xpath.length();
            if (i + 3 < len && xpath.charAt(i + 1) == '*' && xpath.charAt(i + 2) == '/') {
                if (v != null && !(v instanceof List)) {
                    throw new IllegalStateException("xpath=" + xpath + " start=" + start + " not a List");
                }
                List list = v == null ? Collections.emptyList() : (List)v;
                String base = xpath.substring(0, i + 1);
                for (int n = 0; n < list.size(); ++n) {
                    String xp = base + n;
                    Object elem = list.get(n);
                    if (!(elem instanceof State)) {
                        throw new IllegalStateException("xp=" + xp + " not a Map");
                    }
                    State subMap = (State)elem;
                    Type lt = ((ListType)propType.getType()).getFieldType();
                    DBSDocument.readPrefetch((ComplexType)lt, subMap, xp, i + 3, prefetch);
                }
            } else {
                if (v != null && !(v instanceof State)) {
                    throw new IllegalStateException("xpath=" + xpath + " start=" + start + " not a Map");
                }
                State subMap = (State)v;
                DBSDocument.readPrefetch((ComplexType)propType.getType(), subMap, xpath, i + 1, prefetch);
            }
        }
    }

    public void writeDocumentPart(DocumentPart dp) throws PropertyException {
        DBSDocumentState docState = this.getStateMaybeProxyTarget(dp.getType());
        this.writeComplexProperty((ComplexProperty)dp, docState.getState(), docState.getDirty());
        DBSDocument.clearDirtyFlags((Property)dp);
    }

    protected static void clearDirtyFlags(Property property) {
        if (property.isContainer()) {
            for (Property p : property) {
                DBSDocument.clearDirtyFlags(p);
            }
        }
        property.clearDirtyFlags();
    }

    protected void writeComplexProperty(ComplexProperty complexProperty, State state, AtomicBoolean dirty) throws PropertyException {
        if (complexProperty instanceof BlobProperty) {
            this.writeBlobProperty((BlobProperty)complexProperty, state);
            return;
        }
        for (Property property : complexProperty) {
            String name = property.getField().getName().getPrefixedName();
            name = this.internalName(name);
            Type type = property.getType();
            if (type.isSimpleType()) {
                Serializable value = property.getValueForWrite();
                state.put((Object)name, (Object)value);
                dirty.set(true);
                continue;
            }
            if (type.isListType()) {
                ListType listType = (ListType)type;
                if (listType.getFieldType().isSimpleType()) {
                    Object[] value = property.getValueForWrite();
                    if (value instanceof List) {
                        value = ((List)value).toArray(new Object[0]);
                    } else if (value != null && !(value instanceof Object[])) {
                        throw new IllegalStateException(value.toString());
                    }
                    state.put((Object)name, (Object)value);
                    dirty.set(true);
                    continue;
                }
                Collection children = property.getChildren();
                ArrayList<State> childMaps = new ArrayList<State>(children.size());
                for (Property childProperty : children) {
                    State childMap = new State();
                    this.writeComplexProperty((ComplexProperty)childProperty, childMap, dirty);
                    childMaps.add(childMap);
                }
                state.put((Object)name, (Object)childMaps);
                dirty.set(true);
                continue;
            }
            State childMap = (State)state.get((Object)name);
            if (childMap == null) {
                childMap = new State();
                state.put((Object)name, (Object)childMap);
                dirty.set(true);
            }
            this.writeComplexProperty((ComplexProperty)property, childMap, dirty);
        }
    }

    public Set<String> getAllFacets() {
        HashSet<String> facets = new HashSet<String>(this.getType().getFacets());
        facets.addAll(Arrays.asList(this.getFacets()));
        return facets;
    }

    public String[] getFacets() {
        Object[] mixins = (Object[])this.docState.get(KEY_MIXIN_TYPES);
        if (mixins == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] res = new String[mixins.length];
        System.arraycopy(mixins, 0, res, 0, mixins.length);
        return res;
    }

    public boolean hasFacet(String facet) {
        return this.getAllFacets().contains(facet);
    }

    public boolean addFacet(String facet) throws DocumentException {
        if (this.getType().getFacets().contains(facet)) {
            return false;
        }
        Object[] mixins = (Object[])this.docState.get(KEY_MIXIN_TYPES);
        if (mixins == null) {
            mixins = new Object[]{facet};
        } else {
            List<Object> list = Arrays.asList(mixins);
            if (list.contains(facet)) {
                return false;
            }
            list = new ArrayList<Object>(list);
            list.add(facet);
            mixins = list.toArray(new Object[list.size()]);
        }
        this.docState.put(KEY_MIXIN_TYPES, (Serializable)mixins);
        return true;
    }

    public boolean removeFacet(String facet) throws DocumentException {
        Object[] mixins = (Object[])this.docState.get(KEY_MIXIN_TYPES);
        if (mixins == null) {
            return false;
        }
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(mixins));
        if (!list.remove(facet)) {
            return false;
        }
        mixins = list.toArray(new Object[list.size()]);
        if (mixins.length == 0) {
            mixins = null;
        }
        this.docState.put(KEY_MIXIN_TYPES, (Serializable)mixins);
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        CompositeType ft = schemaManager.getFacet(facet);
        for (Field field : ft.getFields()) {
            String name = field.getName().getPrefixedName();
            if (!this.docState.containsKey(name)) continue;
            this.docState.put(name, null);
        }
        return true;
    }

    public Document getTargetDocument() throws DocumentException {
        if (this.isProxy()) {
            String targetId = (String)((Object)this.docState.get(KEY_PROXY_TARGET_ID));
            return this.session.getDocument(targetId);
        }
        return null;
    }

    public void setTargetDocument(Document target) throws DocumentException {
        if (this.isProxy()) {
            if (this.isReadOnly()) {
                throw new DocumentException("Cannot write proxy: " + this);
            }
            if (!target.getVersionSeriesId().equals(this.getVersionSeriesId())) {
                throw new DocumentException("Cannot set proxy target to different version series");
            }
        } else {
            throw new DocumentException("Cannot set proxy target on non-proxy");
        }
        this.session.setProxyTarget(this, target);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getName() + ',' + this.getUUID() + ')';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.equals((DBSDocument)other);
        }
        return false;
    }

    private boolean equals(DBSDocument other) {
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

