/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerDescriptor;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerRootDescriptor;
import org.nuxeo.ecm.core.storage.binary.BinaryScrambler;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public abstract class AbstractBinaryManager
implements BinaryManager {
    public static final String DEFAULT_DIGEST = "MD5";
    public static final int DEFAULT_DEPTH = 2;
    protected String repositoryName;
    protected BinaryManagerRootDescriptor descriptor;
    protected BinaryGarbageCollector garbageCollector;
    public static final int MIN_BUF_SIZE = 8192;
    public static final int MAX_BUF_SIZE = 65536;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    @Override
    public abstract void initialize(BinaryManagerDescriptor var1) throws IOException;

    @Override
    public abstract Binary getBinary(InputStream var1) throws IOException;

    @Override
    public abstract Binary getBinary(String var1);

    protected BinaryManagerRootDescriptor getDescriptor(File configFile) throws IOException {
        BinaryManagerRootDescriptor desc;
        if (configFile.exists()) {
            XMap xmap = new XMap();
            xmap.register(BinaryManagerRootDescriptor.class);
            try {
                desc = (BinaryManagerRootDescriptor)xmap.load((InputStream)new FileInputStream(configFile));
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        } else {
            desc = new BinaryManagerRootDescriptor();
            desc.digest = DEFAULT_DIGEST;
            desc.depth = 2;
            desc.write(configFile);
        }
        return desc;
    }

    protected BinaryScrambler getBinaryScrambler() {
        return NullBinaryScrambler.INSTANCE;
    }

    protected String storeAndDigest(InputStream in, OutputStream out) throws IOException {
        int n;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(this.descriptor.digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw (IOException)new IOException().initCause(e);
        }
        int size = in.available();
        if (size == 0) {
            size = 65536;
        } else if (size < 8192) {
            size = 8192;
        } else if (size > 65536) {
            size = 65536;
        }
        byte[] buf = new byte[size];
        BinaryScrambler scrambler = this.getBinaryScrambler();
        while ((n = in.read(buf)) != -1) {
            scrambler.scrambleBuffer(buf, 0, n);
            digest.update(buf, 0, n);
            out.write(buf, 0, n);
        }
        out.flush();
        return AbstractBinaryManager.toHexString(digest.digest());
    }

    public static String toHexString(byte[] data) {
        StringBuilder buf = new StringBuilder(2 * data.length);
        for (byte b : data) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    @Override
    public BinaryGarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    public static class ScrambledFileInputStream
    extends InputStream {
        protected final InputStream is;
        protected final BinaryScrambler scrambler;
        protected final byte[] onebyte = new byte[1];

        protected ScrambledFileInputStream(File file, BinaryScrambler scrambler) throws IOException {
            this.is = new FileInputStream(file);
            this.scrambler = scrambler;
            scrambler.reset();
        }

        @Override
        public int read() throws IOException {
            int b = this.is.read();
            if (b != -1) {
                this.onebyte[0] = (byte)b;
                this.scrambler.unscrambleBuffer(this.onebyte, 0, 1);
                b = this.onebyte[0];
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.is.read(b, off, len);
            if (n != -1) {
                this.scrambler.unscrambleBuffer(b, off, n);
            }
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            n = this.is.skip(n);
            this.scrambler.skip(n);
            return n;
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }
    }

    public static class ScrambledStreamSource
    extends FileSource {
        protected final BinaryScrambler scrambler;

        public ScrambledStreamSource(File file, BinaryScrambler scrambler) {
            super(file);
            this.scrambler = scrambler;
        }

        public File getFile() {
            throw new UnsupportedOperationException();
        }

        public InputStream getStream() throws IOException {
            return new ScrambledFileInputStream(this.file, this.scrambler);
        }
    }

    public static class ScrambledBinary
    extends Binary {
        private static final long serialVersionUID = 1L;
        private final File file;
        protected final BinaryScrambler scrambler;

        public ScrambledBinary(File file, String digest, String repoName, BinaryScrambler scrambler) {
            super(file, digest, repoName);
            this.file = file;
            this.scrambler = scrambler;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ScrambledFileInputStream(this.file, this.scrambler);
        }

        @Override
        public StreamSource getStreamSource() {
            return new ScrambledStreamSource(this.file, this.scrambler);
        }
    }

    public static class NullBinaryScrambler
    implements BinaryScrambler {
        private static final long serialVersionUID = 1L;
        public static final BinaryScrambler INSTANCE = new NullBinaryScrambler();

        @Override
        public void scrambleBuffer(byte[] buf, int off, int n) {
        }

        @Override
        public void unscrambleBuffer(byte[] buf, int off, int n) {
        }

        @Override
        public Binary getUnscrambledBinary(File file, String digest, String repoName) {
            return new Binary(file, digest, repoName);
        }

        @Override
        public void skip(long n) {
        }

        @Override
        public void reset() {
        }
    }
}

