/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentListIterator;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.runtime.api.Framework;

public class SQLDocumentLive
implements SQLDocument {
    protected final Node node;
    protected final Type type;
    protected SQLSession session;
    protected final List<Schema> proxySchemas;
    protected boolean readonly;
    protected static final Map<String, String> systemPropNameMap = new HashMap<String, String>();

    protected SQLDocumentLive(Node node, ComplexType type, SQLSession session, boolean readonly) {
        this.node = node;
        this.type = type;
        this.session = session;
        if (node != null && node.isProxy()) {
            SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
            this.proxySchemas = schemaManager.getProxySchemas(type.getName());
        } else {
            this.proxySchemas = null;
        }
        this.readonly = readonly;
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.getNode() == null ? null : this.getNode().getName();
    }

    public DocumentType getType() {
        return (DocumentType)this.type;
    }

    public SQLSession getSession() {
        return this.session;
    }

    public boolean isFolder() {
        return this.type == null || ((DocumentType)this.type).isFolder();
    }

    public String getUUID() {
        return this.session.idToString(this.getNode().getId());
    }

    public Document getParent() throws DocumentException {
        return this.session.getParent(this.getNode());
    }

    public String getPath() throws DocumentException {
        return this.session.getPath(this.getNode());
    }

    public boolean isProxy() {
        return false;
    }

    public String getRepositoryName() {
        return this.session.getRepositoryName();
    }

    public void remove() throws DocumentException {
        this.session.remove(this.getNode());
    }

    public void readDocumentPart(DocumentPart dp) throws PropertyException {
        this.session.readComplexProperty((ComplexProperty)dp, this.getNode());
    }

    public Map<String, Serializable> readPrefetch(ComplexType complexType, Set<String> xpaths) throws PropertyException {
        return this.session.readPrefetch(this.getNode(), complexType, xpaths);
    }

    public void writeDocumentPart(DocumentPart dp) throws PropertyException {
        this.session.writeComplexProperty((ComplexProperty)dp, this.getNode(), this);
        SQLDocumentLive.clearDirtyFlags((Property)dp);
    }

    protected static void clearDirtyFlags(Property property) {
        if (property.isContainer()) {
            for (Property p : property) {
                SQLDocumentLive.clearDirtyFlags(p);
            }
        }
        property.clearDirtyFlags();
    }

    public Serializable getPropertyValue(String name) throws DocumentException {
        try {
            return this.getNode().getSimpleProperty(name).getValue();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public void setPropertyValue(String name, Serializable value) throws DocumentException {
        try {
            this.getNode().setSimpleProperty(name, value);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public void setSystemProp(String name, Serializable value) throws DocumentException {
        String propertyName = name.startsWith("simpleText") ? name.replace("simpleText", "ecm:simpleText") : (name.startsWith("binaryText") ? name.replace("binaryText", "ecm:binaryText") : systemPropNameMap.get(name));
        if (propertyName == null) {
            throw new DocumentException("Unknown system property: " + name);
        }
        this.setPropertyValue(propertyName, value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) throws DocumentException {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new DocumentException("Unknown system property: " + name);
        }
        Serializable value = this.getPropertyValue(propertyName);
        if (value == null) {
            if (type == Boolean.class) {
                value = Boolean.FALSE;
            } else if (type == Long.class) {
                value = Long.valueOf(0L);
            }
        }
        return (T)value;
    }

    public String getLifeCyclePolicy() throws LifeCycleException {
        try {
            return (String)((Object)this.getPropertyValue("ecm:lifeCyclePolicy"));
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to get policy", (Throwable)e);
        }
    }

    public void setLifeCyclePolicy(String policy) throws LifeCycleException {
        try {
            this.setPropertyValue("ecm:lifeCyclePolicy", (Serializable)((Object)policy));
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to set policy", (Throwable)e);
        }
    }

    public String getLifeCycleState() throws LifeCycleException {
        try {
            return (String)((Object)this.getPropertyValue("ecm:lifeCycleState"));
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to get state", (Throwable)e);
        }
    }

    public void setCurrentLifeCycleState(String state) throws LifeCycleException {
        try {
            this.setPropertyValue("ecm:lifeCycleState", (Serializable)((Object)state));
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to set state", (Throwable)e);
        }
    }

    public void followTransition(String transition) throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        service.followTransition((Document)this, transition);
    }

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        LifeCycle lifeCycle = service.getLifeCycleFor((Document)this);
        if (lifeCycle == null) {
            return Collections.emptyList();
        }
        return lifeCycle.getAllowedStateTransitionsFrom(this.getLifeCycleState());
    }

    public Lock getLock() throws DocumentException {
        return this.session.getLock(this.getNode());
    }

    public Lock setLock(Lock lock) throws DocumentException {
        return this.session.setLock(this.getNode(), lock);
    }

    public Lock removeLock(String owner) throws DocumentException {
        return this.session.removeLock(this.getNode(), owner);
    }

    public boolean isVersion() {
        return false;
    }

    public Document getBaseVersion() throws DocumentException {
        if (this.isCheckedOut()) {
            return null;
        }
        Serializable id = this.getPropertyValue("ecm:baseVersion");
        if (id == null) {
            return null;
        }
        return this.session.getDocumentById(id);
    }

    public String getVersionSeriesId() throws DocumentException {
        return this.getUUID();
    }

    public Document getSourceDocument() throws DocumentException {
        return this;
    }

    public Document checkIn(String label, String checkinComment) throws DocumentException {
        return this.session.checkIn(this.getNode(), label, checkinComment);
    }

    public void checkOut() throws DocumentException {
        this.session.checkOut(this.getNode());
    }

    public boolean isCheckedOut() throws DocumentException {
        return !Boolean.TRUE.equals(this.getPropertyValue("ecm:isCheckedIn"));
    }

    public boolean isMajorVersion() throws DocumentException {
        return false;
    }

    public boolean isLatestVersion() throws DocumentException {
        return false;
    }

    public boolean isLatestMajorVersion() throws DocumentException {
        return false;
    }

    public boolean isVersionSeriesCheckedOut() throws DocumentException {
        return this.isCheckedOut();
    }

    public String getVersionLabel() throws DocumentException {
        return (String)((Object)this.getPropertyValue("ecm:versionLabel"));
    }

    public String getCheckinComment() throws DocumentException {
        return (String)((Object)this.getPropertyValue("ecm:versionDescription"));
    }

    public Document getWorkingCopy() throws DocumentException {
        return this;
    }

    public Calendar getVersionCreationDate() throws DocumentException {
        return (Calendar)this.getPropertyValue("ecm:versionCreated");
    }

    public void restore(Document version) throws DocumentException {
        if (!version.isVersion()) {
            throw new DocumentException("Cannot restore a non-version: " + version);
        }
        this.session.restore(this.getNode(), ((SQLDocument)version).getNode());
    }

    public List<String> getVersionsIds() throws DocumentException {
        String versionSeriesId = this.getVersionSeriesId();
        List<Document> versions = this.session.getVersions(versionSeriesId);
        ArrayList<String> ids = new ArrayList<String>(versions.size());
        for (Document version : versions) {
            ids.add(version.getUUID());
        }
        return ids;
    }

    public Document getVersion(String label) throws DocumentException {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getVersionByLabel(versionSeriesId, label);
    }

    public List<Document> getVersions() throws DocumentException {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getVersions(versionSeriesId);
    }

    public Document getLastVersion() throws DocumentException {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getLastVersion(versionSeriesId);
    }

    public Document getChild(String name) throws DocumentException {
        return this.session.getChild(this.getNode(), name);
    }

    public Iterator<Document> getChildren() throws DocumentException {
        if (!this.isFolder()) {
            return EmptyDocumentIterator.INSTANCE;
        }
        List<Document> children = this.session.getChildren(this.getNode());
        return new SQLDocumentListIterator(children);
    }

    public List<String> getChildrenIds() throws DocumentException {
        if (!this.isFolder()) {
            return Collections.emptyList();
        }
        List<Document> children = this.session.getChildren(this.getNode());
        ArrayList<String> ids = new ArrayList<String>(children.size());
        for (Document child : children) {
            ids.add(child.getUUID());
        }
        return ids;
    }

    public boolean hasChild(String name) throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChild(this.getNode(), name);
    }

    public boolean hasChildren() throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChildren(this.getNode());
    }

    public Document addChild(String name, String typeName) throws DocumentException {
        if (!this.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        return this.session.addChild(this.getNode(), name, null, typeName);
    }

    public void orderBefore(String src, String dest) throws DocumentException {
        SQLDocument destDoc;
        SQLDocument srcDoc = (SQLDocument)this.getChild(src);
        if (srcDoc == null) {
            throw new DocumentException("Document " + this + " has no child: " + src);
        }
        if (dest == null) {
            destDoc = null;
        } else {
            destDoc = (SQLDocument)this.getChild(dest);
            if (destDoc == null) {
                throw new DocumentException("Document " + this + " has no child: " + dest);
            }
        }
        this.session.orderBefore(this.getNode(), srcDoc.getNode(), destDoc == null ? null : destDoc.getNode());
    }

    public Set<String> getAllFacets() {
        return this.getNode().getAllMixinTypes();
    }

    public String[] getFacets() {
        return this.getNode().getMixinTypes();
    }

    public boolean hasFacet(String facet) {
        return this.getNode().hasMixinType(facet);
    }

    public boolean addFacet(String facet) throws DocumentException {
        return this.session.addMixinType(this.getNode(), facet);
    }

    public boolean removeFacet(String facet) throws DocumentException {
        return this.session.removeMixinType(this.getNode(), facet);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getName() + ',' + this.getUUID() + ')';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.equals((SQLDocumentLive)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentLive other) {
        return this.getNode().equals((Object)other.getNode());
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }

    public Document getTargetDocument() {
        return null;
    }

    public void setTargetDocument(Document target) throws DocumentException {
        throw new DocumentException();
    }

    static {
        systemPropNameMap.put("fulltextJobId", "ecm:fulltextJobId");
    }
}

