/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.platform.web.common.resources.JSMinimizer;
import org.nuxeo.runtime.api.Framework;

public class AggregatedJSProvider
extends HttpServlet {
    public static final String MINIMIZER_IMPL_KEY = "org.nuxeo.ecm.platform.web.common.resources.JSMinimizer";
    protected static final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    protected static final Map<String, String> cachedResponses = new HashMap<String, String>();
    protected static JSMinimizer minimizer;
    protected static final String SCRIPT_SEP = "\\|";
    private static final long serialVersionUID = 1L;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String scriptsStr = req.getParameter("scripts");
        String refreshStr = req.getParameter("refresh");
        String minimizeStr = req.getParameter("minimize");
        boolean minimize = "true".equalsIgnoreCase(minimizeStr);
        boolean refresh = "true".equalsIgnoreCase(refreshStr);
        if (scriptsStr == null) {
            super.doGet(req, resp);
            return;
        }
        String cacheKey = scriptsStr + "*" + minimize;
        String resultScript = null;
        if (!refresh && !Framework.isDevModeSet()) {
            cacheLock.readLock().lock();
            try {
                resultScript = cachedResponses.get(cacheKey);
            }
            finally {
                cacheLock.readLock().unlock();
            }
        }
        if (resultScript == null) {
            String[] scripts = scriptsStr.split(SCRIPT_SEP);
            resultScript = this.computeResult(scripts, minimize);
            if (!Framework.isDevModeSet()) {
                cacheLock.writeLock().lock();
                try {
                    cachedResponses.put(cacheKey, resultScript);
                }
                finally {
                    cacheLock.writeLock().unlock();
                }
            }
        }
        resp.getWriter().write(resultScript);
    }

    protected String computeResult(String[] scripts, boolean minimize) throws IOException {
        String fsPath = this.getServletContext().getRealPath("/");
        Path dirPath = new Path(fsPath).append("scripts");
        StringBuffer buf = new StringBuffer();
        for (String script : scripts) {
            Path scriptPath = dirPath.append(script = script.replaceAll("\\.\\./", ""));
            File scriptFile = new File(scriptPath.toString());
            if (!scriptFile.exists()) continue;
            buf.append("// *******************************\n");
            buf.append("// include script " + script + "\n");
            FileInputStream is = new FileInputStream(scriptFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            ((InputStream)is).close();
            buf.append(sb.toString());
            buf.append("\n");
        }
        if (minimize && !Framework.isDevModeSet()) {
            return this.minimize(buf.toString());
        }
        return buf.toString();
    }

    protected String minimize(String jsContent) {
        return this.getMinimizer().minimize(jsContent);
    }

    protected JSMinimizer getMinimizer() {
        if (minimizer == null) {
            String minimizerClassName = this.getServletContext().getInitParameter(MINIMIZER_IMPL_KEY);
            if (minimizerClassName == null) {
                minimizerClassName = this.getInitParameter(MINIMIZER_IMPL_KEY);
            }
            if (minimizerClassName != null) {
                try {
                    Class<?> minimizerClass = Thread.currentThread().getContextClassLoader().loadClass(minimizerClassName);
                    minimizer = (JSMinimizer)minimizerClass.newInstance();
                }
                catch (Exception e) {
                    log.error((Object)"Error while getting minimizer implementation", (Throwable)e);
                }
            }
        }
        if (minimizer == null) {
            minimizer = new DummyMinimizer();
        }
        return minimizer;
    }

    static {
        log = LogFactory.getLog(AggregatedJSProvider.class);
    }

    protected class DummyMinimizer
    implements JSMinimizer {
        protected DummyMinimizer() {
        }

        @Override
        public String minimize(String jsScriptContent) {
            StringBuilder sb = new StringBuilder();
            sb.append("// No (correct) JSMinimizer implementation class was defined\n");
            sb.append("please check web.xml to set init parameter\n");
            sb.append(jsScriptContent);
            return sb.toString();
        }
    }
}

