/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.media.publishing.MediaPublishingService;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.ecm.media.publishing.upload.MediaPublishingUploadWork;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="mediaPublishing")
@Scope(value=ScopeType.EVENT)
public class MediaPublishingActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MEDIA_PUBLISHING_OPTIONS_CATEGORY = "MEDIA_PUBLISHING_OPTIONS_CATEGORY";
    private static final Log log = LogFactory.getLog(MediaPublishingActions.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true, required=false)
    protected transient ActionContextProvider actionContextProvider;
    @In(create=true, required=false)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    private static String selectedAccount;
    private Map<String, Object> providersStats = new HashMap<String, Object>();
    private Map<String, String> providersURL;
    private Map<String, String> providersEmbedCode = new HashMap<String, String>();
    private Map<String, Boolean> publishedProviders;
    Map<String, String> options;
    private DocumentModel currentDoc;

    public MediaPublishingActions() {
        this.providersURL = new HashMap<String, String>();
        this.options = new HashMap<String, String>();
        this.publishedProviders = new HashMap<String, Boolean>();
    }

    public String[] getAvailableServices(DocumentModel doc) {
        return this.getMediaPublishingService().getAvailableProviders(doc);
    }

    public UploadStatus getUploadStatus(DocumentModel doc, String uploadServiceName) {
        String workId;
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        Work.State state = workManager.getWorkState(workId = MediaPublishingUploadWork.getIdFor((String)doc.getRepositoryName(), (String)doc.getId(), (String)uploadServiceName));
        if (state == null) {
            return null;
        }
        switch (state) {
            case SCHEDULED: {
                return new UploadStatus("status.video.uploadQueued", new Work.Progress(0.0f));
            }
            case RUNNING: {
                return new UploadStatus("status.video.uploadPending", new Work.Progress(0.0f));
            }
        }
        return null;
    }

    public boolean isPublished(DocumentModel doc, String provider) {
        if (!this.publishedProviders.containsKey(provider)) {
            PublishableMedia media = (PublishableMedia)doc.getAdapter(PublishableMedia.class);
            boolean isPublished = media != null && media.getId(provider) != null && media.isPublishedByProvider(provider);
            this.publishedProviders.put(provider, isPublished);
        }
        return this.publishedProviders.get(provider);
    }

    public String getPublishedURL(DocumentModel doc, String provider) {
        String url = this.providersURL.get(provider);
        if (url == null) {
            PublishableMedia media = (PublishableMedia)doc.getAdapter(PublishableMedia.class);
            url = media.getUrl(provider);
            this.providersURL.put(provider, url);
        }
        return url;
    }

    public void publish(String provider) {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (selectedAccount == null || selectedAccount.length() == 0) {
            return;
        }
        this.getMediaPublishingService().publish(doc, provider, selectedAccount, this.options);
        selectedAccount = null;
    }

    public void unpublish(String provider) {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        this.getMediaPublishingService().unpublish(doc, provider);
        this.publishedProviders.remove(provider);
    }

    public String getEmbedCode(DocumentModel doc, String provider) {
        String embedCode = this.providersEmbedCode.get(provider);
        if (embedCode == null) {
            PublishableMedia media = (PublishableMedia)doc.getAdapter(PublishableMedia.class);
            embedCode = media.getEmbedCode(provider);
            this.providersEmbedCode.put(provider, embedCode);
        }
        return embedCode;
    }

    public Map<String, String> getStats(DocumentModel doc, String provider) {
        Map stats = (Map)this.providersStats.get(provider);
        if (stats == null) {
            PublishableMedia media = (PublishableMedia)doc.getAdapter(PublishableMedia.class);
            stats = media.getStats(provider);
            this.providersStats.put(provider, stats);
        }
        return stats;
    }

    private MediaPublishingService getMediaPublishingService() {
        return (MediaPublishingService)Framework.getService(MediaPublishingService.class);
    }

    public String getStatusMessageFor(UploadStatus status) {
        if (status == null) {
            return "";
        }
        String i18nMessageTemplate = (String)this.resourcesAccessor.getMessages().get(status.getMessage());
        if (i18nMessageTemplate == null) {
            return "";
        }
        return Interpolator.instance().interpolate(i18nMessageTemplate, new Object[]{status.positionInQueue, status.queueSize, status.progress.getCurrent()});
    }

    public String getSelectedAccount() {
        return selectedAccount;
    }

    public void setSelectedAccount(String selectedAccount) {
        MediaPublishingActions.selectedAccount = selectedAccount;
    }

    public DocumentModel getCurrentDoc() {
        if (this.currentDoc == null) {
            this.currentDoc = this.navigationContext.getCurrentDocument();
            this.currentDoc.refresh();
        }
        return this.currentDoc;
    }

    public List<Action> getProviderOptionsWidgets(String provider) {
        ActionContext ctx = this.actionContextProvider.createActionContext();
        ctx.putLocalVariable("provider", (Object)provider);
        return this.webActions.getActionsList(MEDIA_PUBLISHING_OPTIONS_CATEGORY, ctx);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public boolean canPublish(String provider) {
        return this.getMediaPublishingService().getProvider(provider).isAvailable();
    }

    public boolean isMediaAvailable(DocumentModel doc, String provider) {
        PublishableMedia media = (PublishableMedia)doc.getAdapter(PublishableMedia.class);
        return this.getMediaPublishingService().getProvider(provider).isMediaAvailable(media);
    }

    public class UploadStatus {
        public static final String STATUS_UPLOAD_QUEUED = "status.video.uploadQueued";
        public static final String STATUS_UPLOAD_PENDING = "status.video.uploadPending";
        public final String message;
        public final int positionInQueue;
        public final int queueSize;
        public final Work.Progress progress;

        public UploadStatus(String message, Work.Progress progress) {
            this(message, progress, 0, 0);
        }

        public UploadStatus(String message, Work.Progress progress, int positionInQueue, int queueSize) {
            this.message = message;
            this.progress = progress;
            this.positionInQueue = positionInQueue;
            this.queueSize = queueSize;
        }

        public String getMessage() {
            return this.message;
        }

        public Work.Progress getProgress() {
            return this.progress;
        }

        public int getPositionInQueue() {
            return this.positionInQueue;
        }

        public int getQueueSize() {
            return this.queueSize;
        }
    }
}

