/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.adapter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.media.publishing.MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.MediaPublishingService;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.runtime.api.Framework;

public class PublishableMediaAdapter
implements PublishableMedia {
    final DocumentModel doc;

    public PublishableMediaAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public Map<String, Object> getProvider(String provider) {
        List<Map<String, Object>> providers = this.getProviders();
        for (Map<String, Object> entry : providers) {
            if (!entry.get("provider").equals(provider)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void putProvider(Map<String, Object> provider) {
        List<Map<String, Object>> providers = this.getProviders();
        boolean providerExists = false;
        for (Map<String, Object> entry : providers) {
            if (!entry.get("provider").equals(provider.get("provider"))) continue;
            entry.put("externalId", provider.get("externalId"));
            entry.put("account", provider.get("account"));
            providerExists = true;
            break;
        }
        if (!providerExists) {
            providers.add(provider);
        }
        this.doc.setPropertyValue("pm:providers", (Serializable)((Object)providers));
    }

    @Override
    public void removeProvider(String provider) {
        List<Map<String, Object>> providers = this.getProviders();
        Map<String, Object> providerEntry = this.getProvider(provider);
        providers.remove(providerEntry);
        this.setProviders(providers);
    }

    @Override
    public boolean isPublishedByProvider(String provider) {
        List<Map<String, Object>> providers = this.getProviders();
        for (Map<String, Object> entry : providers) {
            if (!entry.get("provider").equals(provider)) continue;
            String mediaId = (String)entry.get("externalId");
            String account = (String)entry.get("account");
            if (!this.getMediaPublishingProvider(provider).isMediaPublished(mediaId, account)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Map<String, Object>> getProviders() {
        return (List)((Object)this.doc.getPropertyValue("pm:providers"));
    }

    @Override
    public void setProviders(List<Map<String, Object>> providers) {
        this.doc.setPropertyValue("pm:providers", (Serializable)((Object)providers));
    }

    @Override
    public String getId(String provider) {
        Map<String, Object> entry = this.getProvider(provider);
        if (entry == null) {
            return null;
        }
        return (String)entry.get("externalId");
    }

    @Override
    public String getAccount(String provider) {
        Map<String, Object> entry = this.getProvider(provider);
        if (entry == null) {
            return null;
        }
        return (String)entry.get("account");
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public String getTitle() {
        return this.doc.getTitle();
    }

    @Override
    public String getDescription() {
        return (String)((Object)this.doc.getPropertyValue("dc:description"));
    }

    @Override
    public Blob getBlob() {
        return ((BlobHolder)this.doc.getAdapter(BlobHolder.class)).getBlob();
    }

    @Override
    public String getUrl(String provider) {
        return this.getMediaPublishingProvider(provider).getPublishedUrl(this.getId(provider), this.getAccount(provider));
    }

    @Override
    public String getEmbedCode(String provider) {
        return this.getMediaPublishingProvider(provider).getEmbedCode(this.getId(provider), this.getAccount(provider));
    }

    @Override
    public Map<String, String> getStats(String provider) {
        return this.getMediaPublishingProvider(provider).getStats(this.getId(provider), this.getAccount(provider));
    }

    private MediaPublishingProvider getMediaPublishingProvider(String provider) {
        return this.getMediaPublishingService().getProvider(provider);
    }

    private MediaPublishingService getMediaPublishingService() {
        return (MediaPublishingService)Framework.getService(MediaPublishingService.class);
    }
}

