/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XSInteger;
import com.marklogic.xcc.types.impl.AbstractStringItem;
import java.math.BigInteger;

public class XsIntegerImpl
extends AbstractStringItem
implements XSInteger {
    private BigInteger value;

    public XsIntegerImpl(String value) {
        super(ValueType.XS_INTEGER, value);
        this.value = new BigInteger(value);
    }

    public XsIntegerImpl(Object value) {
        super(ValueType.XS_INTEGER, value.toString());
        if (!(value instanceof Integer || value instanceof Long || value instanceof BigInteger || value instanceof String)) {
            throw new IllegalArgumentException("Cannot construct XSInteger from " + value.getClass().getName());
        }
        this.value = new BigInteger(value.toString());
    }

    @Override
    public BigInteger asBigInteger() {
        return this.value;
    }

    @Override
    public Long asLong() {
        return new Long(this.value.longValue());
    }

    @Override
    public long asPrimitiveLong() {
        return this.value.longValue();
    }

    @Override
    public Integer asInteger() {
        return Integer.valueOf(this.asString());
    }

    @Override
    public int asPrimitiveInt() {
        return (int)this.asPrimitiveLong();
    }
}

