/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XSDecimal;
import com.marklogic.xcc.types.impl.AbstractStringItem;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XsDecimalImpl
extends AbstractStringItem
implements XSDecimal {
    private final BigDecimal value;

    public XsDecimalImpl(String bodyString) {
        super(ValueType.XS_DECIMAL, bodyString);
        this.value = new BigDecimal(bodyString);
    }

    public XsDecimalImpl(Object value) {
        super(ValueType.XS_DECIMAL, value.toString());
        if (!(value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof BigDecimal || value instanceof BigInteger || value instanceof String)) {
            throw new IllegalArgumentException("Cannot construct XSDecimal from " + value.getClass().getName());
        }
        this.value = new BigDecimal(value.toString());
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.value;
    }
}

