/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.http;

import com.marklogic.http.MultipartSplitter;
import java.io.IOException;
import java.io.InputStream;

public class PartInputStream
extends InputStream {
    private MultipartSplitter splitter;

    public PartInputStream(MultipartSplitter splitter) {
        this.splitter = splitter;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void close() {
        this.splitter = null;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.splitter.read();
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this.splitter == null) {
            throw new IOException("Splitter stream closed");
        }
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            throw new IndexOutOfBoundsException("offset or length error");
        }
        return this.splitter.read(buf, offset, len);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0x40000000L) {
            byte[] buf = new byte[(int)n];
            return this.read(buf, 0, (int)n);
        }
        byte[] buf = new byte[0x40000000];
        long resultLen = 0L;
        long residualLen = n;
        int m = 0x40000000;
        while ((long)m < n) {
            resultLen += (long)this.read(buf, 0, residualLen < 0x40000000L ? (int)residualLen : 0x40000000);
            m += 0x40000000;
            residualLen -= 0x40000000L;
        }
        return resultLen;
    }
}

