/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentbaseMetaData;
import com.marklogic.xcc.ModuleInvoke;
import com.marklogic.xcc.ModuleSpawn;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.exceptions.RequestException;
import java.io.Closeable;
import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public interface Session
extends Closeable {
    public ContentSource getContentSource();

    public UserCredentials getUserCredentials();

    public String getContentBaseName();

    public XAResource getXAResource();

    public void setTransactionMode(TransactionMode var1);

    public TransactionMode getTransactionMode();

    public void setTransactionTimeout(int var1) throws RequestException;

    public int getTransactionTimeout() throws RequestException;

    public int getCachedTxnTimeout();

    public void commit() throws RequestException;

    public void rollback() throws RequestException;

    @Override
    public void close();

    public boolean isClosed();

    public ResultSequence submitRequest(Request var1) throws RequestException;

    public AdhocQuery newAdhocQuery(String var1, RequestOptions var2);

    public AdhocQuery newAdhocQuery(String var1);

    public ModuleInvoke newModuleInvoke(String var1, RequestOptions var2);

    public ModuleInvoke newModuleInvoke(String var1);

    public ModuleSpawn newModuleSpawn(String var1, RequestOptions var2);

    public ModuleSpawn newModuleSpawn(String var1);

    public void insertContent(Content var1) throws RequestException;

    public void insertContent(Content[] var1) throws RequestException;

    public List<RequestException> insertContentCollectErrors(Content[] var1) throws RequestException;

    public ContentbaseMetaData getContentbaseMetaData();

    public void setDefaultRequestOptions(RequestOptions var1);

    public RequestOptions getDefaultRequestOptions();

    public RequestOptions getEffectiveRequestOptions();

    public BigInteger getCurrentServerPointInTime() throws RequestException;

    public Logger getLogger();

    public void setLogger(Logger var1);

    public void setUserObject(Object var1);

    public Object getUserObject();

    public URI getConnectionUri();

    public static enum TransactionMode {
        AUTO{

            @Override
            public String toString() {
                return "auto";
            }
        }
        ,
        QUERY{

            @Override
            public String toString() {
                return "query";
            }
        }
        ,
        UPDATE{

            @Override
            public String toString() {
                return "update";
            }

            @Override
            public boolean isRetryable() {
                return false;
            }
        }
        ,
        UPDATE_AUTO_COMMIT{

            @Override
            public String toString() {
                return "update-auto-commit";
            }
        };


        public abstract String toString();

        public boolean isRetryable() {
            return true;
        }
    }
}

