/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.marklogic;

import java.util.Calendar;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nuxeo.ecm.core.api.model.Delta;

final class MarkLogicHelper {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final String DOCUMENT_ROOT = "document";
    public static final String DOCUMENT_ROOT_PATH = "/document";
    public static final String ARRAY_ITEM_KEY_SUFFIX = "__item";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_XSI_TYPE = "xsi:type";
    public static final char SCHEMA_ORIGINAL_DELIMITER = ':';
    public static final String SCHEMA_MARKLOGIC_DELIMITER = "__";

    MarkLogicHelper() {
    }

    public static String serializeCalendar(Calendar cal) {
        return DateTime.now().withMillis(cal.getTimeInMillis()).toString(DATE_TIME_FORMATTER);
    }

    public static Calendar deserializeCalendar(String calString) {
        DateTime dateTime = DATE_TIME_FORMATTER.parseDateTime(calString);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateTime.toDate());
        return cal;
    }

    public static String serializeKey(String nxKey) {
        StringBuilder mlKey = new StringBuilder(nxKey.length());
        for (int i = 0; i < nxKey.length(); ++i) {
            char c = nxKey.charAt(i);
            if (c == ':') {
                mlKey.append(SCHEMA_MARKLOGIC_DELIMITER);
                continue;
            }
            mlKey.append(c);
        }
        return mlKey.toString();
    }

    public static String deserializeKey(String mlKey) {
        StringBuilder nxKey = new StringBuilder(mlKey.length());
        boolean underscore = false;
        for (int i = 0; i < mlKey.length(); ++i) {
            boolean underscoreNext = false;
            char c = mlKey.charAt(i);
            if (c == '_') {
                if (underscore) {
                    nxKey.append(':');
                } else {
                    underscoreNext = true;
                }
            } else {
                if (underscore) {
                    nxKey.append('_');
                }
                nxKey.append(c);
            }
            underscore = underscoreNext;
        }
        return nxKey.toString();
    }

    public static String getLastElementName(String path) {
        return path.replaceAll("^(.*/)?([^/]*)$", "$2");
    }

    public static String buildItemNameFromPath(String path) {
        return MarkLogicHelper.getLastElementName(path) + ARRAY_ITEM_KEY_SUFFIX;
    }

    public static enum ElementType {
        BOOLEAN("xs:boolean", "boolean"),
        DOUBLE("xs:double", "double"),
        LONG("xs:long", "long"),
        CALENDAR("xs:dateTime", "dateTime"),
        STRING("xs:string", "string");

        private final String key;
        private final String keyWithoutNamespace;

        private ElementType(String key, String keyWithoutNamespace) {
            this.key = key;
            this.keyWithoutNamespace = keyWithoutNamespace;
        }

        public String get() {
            return this.key;
        }

        public String getWithoutNamespace() {
            return this.keyWithoutNamespace;
        }

        public static ElementType of(String string) {
            String type = string.toLowerCase();
            for (ElementType elementType : ElementType.values()) {
                if (!elementType.get().equalsIgnoreCase(type)) continue;
                return elementType;
            }
            return null;
        }

        public static ElementType getType(Object object) {
            return ElementType.getType(object == null ? null : object.getClass());
        }

        public static ElementType getType(Class<?> clazz) {
            if (Boolean.class.isAssignableFrom(clazz)) {
                return BOOLEAN;
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return DOUBLE;
            }
            if (Long.class.isAssignableFrom(clazz) || Delta.class.isAssignableFrom(clazz)) {
                return LONG;
            }
            if (Calendar.class.isAssignableFrom(clazz) || DateTime.class.isAssignableFrom(clazz)) {
                return CALENDAR;
            }
            return STRING;
        }
    }
}

