/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.xcc.Request;
import com.marklogic.xcc.ValueFactory;
import com.marklogic.xcc.exceptions.JavaScriptException;
import com.marklogic.xcc.exceptions.QueryException;
import com.marklogic.xcc.exceptions.QueryStackFrame;
import com.marklogic.xcc.exceptions.RequestServerException;
import com.marklogic.xcc.exceptions.RetryableJavaScriptException;
import com.marklogic.xcc.exceptions.RetryableXQueryException;
import com.marklogic.xcc.exceptions.XQueryException;
import com.marklogic.xcc.types.XName;
import com.marklogic.xcc.types.XdmVariable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ServerErrorParser {
    private static final boolean VALIDATING = false;
    private static final boolean NAMESPACE = true;
    private static final SAXParserFactory factory = SAXParserFactory.newInstance();

    private ServerErrorParser() {
    }

    public static RequestServerException makeException(Request request, String exceptionNode) {
        ArrayList<RequestServerException> exceptions = new ArrayList<RequestServerException>();
        try {
            InputSource is = new InputSource(new StringReader(exceptionNode));
            SAXParser parser = factory.newSAXParser();
            SaxHandler handler = new SaxHandler(request, exceptions);
            XMLReader xmlr = parser.getXMLReader();
            xmlr.setContentHandler(handler);
            xmlr.setErrorHandler(handler);
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXParseException e) {
            return new RequestServerException("SAX Error parsing server exception: " + e, request, e);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            exceptions.add(new RequestServerException("ErrorParser: " + message, request, e));
        }
        if (exceptions.size() == 0) {
            return new RequestServerException("Failed to parse server exception: " + exceptionNode, request);
        }
        return (RequestServerException)exceptions.get(0);
    }

    static {
        factory.setValidating(false);
        factory.setNamespaceAware(true);
    }

    private static class SaxHandler
    extends DefaultHandler {
        private final Request request;
        private final List<RequestServerException> exceptionList;
        private final StringBuffer sb = new StringBuffer(512);
        private String code = null;
        private String w3cCode = null;
        private String xqueryVersion = null;
        private LinkedList<String> xqueryVersionStack = new LinkedList();
        private String formatString = null;
        private boolean retryable = false;
        private String contextItem = null;
        private String message = null;
        private String name = null;
        private String expr = null;
        private String operation = null;
        private String uri = null;
        private String value = null;
        private int contextPosition = 0;
        private int line = 0;
        private List<String> dataList = new ArrayList<String>();
        private List<QueryStackFrame> stackList = new ArrayList<QueryStackFrame>();
        private List<String> variablesList = new ArrayList<String>();
        private boolean isJavaScript;

        public SaxHandler(Request request, List<RequestServerException> exceptionList) {
            this.request = request;
            this.exceptionList = exceptionList;
            if (request != null && request.getOptions() != null && "javascript".equalsIgnoreCase(request.getOptions().getQueryLanguage())) {
                this.isJavaScript = true;
            }
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.sb.setLength(0);
            if (localName.equals("data")) {
                this.dataList.clear();
                return;
            }
            if (localName.equals("error")) {
                this.code = null;
                this.w3cCode = null;
                this.message = null;
                this.formatString = null;
                this.retryable = false;
                this.xqueryVersionStack.clear();
                this.xqueryVersion = "0.9-ml";
                this.dataList.clear();
                this.stackList.clear();
                return;
            }
            if (localName.equals("frame")) {
                this.uri = null;
                this.line = 0;
                this.operation = null;
                this.variablesList.clear();
                this.contextItem = null;
                this.contextPosition = 0;
                this.xqueryVersionStack.addLast(this.xqueryVersion);
                this.xqueryVersion = "0.9-ml";
                return;
            }
            if (localName.equals("stack")) {
                this.stackList.clear();
                return;
            }
            if (localName.equals("variable")) {
                this.name = null;
                this.value = null;
                return;
            }
            if (localName.equals("variables")) {
                this.variablesList.clear();
                return;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.sb.append(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("code")) {
                this.code = this.sb.toString();
            }
            if (localName.equals("name")) {
                this.w3cCode = this.sb.toString();
                if (this.w3cCode != null && this.w3cCode.length() == 0) {
                    this.w3cCode = null;
                }
            }
            if (localName.equals("xquery-version")) {
                this.xqueryVersion = this.sb.toString();
                if (this.xqueryVersion != null && this.xqueryVersion.length() == 0) {
                    this.xqueryVersion = null;
                }
            }
            if (localName.equals("context-item")) {
                this.contextItem = this.sb.toString();
            }
            if (localName.equals("context-position")) {
                this.contextPosition = Integer.parseInt(this.sb.toString());
            }
            if (localName.equals("datum")) {
                this.dataList.add(this.sb.toString());
            }
            if (localName.equals("error")) {
                String[] data = null;
                data = this.dataList.toArray(new String[this.dataList.size()]);
                QueryStackFrame[] stack = null;
                stack = this.stackList.toArray(new QueryStackFrame[this.stackList.size()]);
                QueryException eee = this.retryable ? (this.isJavaScript ? new RetryableJavaScriptException(this.request, this.code, this.w3cCode, this.message, this.formatString, this.expr, this.retryable, data, stack) : new RetryableXQueryException(this.request, this.code, this.w3cCode, this.xqueryVersion, this.message, this.formatString, this.expr, this.retryable, data, stack)) : (this.isJavaScript ? new JavaScriptException(this.request, this.code, this.w3cCode, this.message, this.formatString, this.expr, this.retryable, data, stack) : new XQueryException(this.request, this.code, this.w3cCode, this.xqueryVersion, this.message, this.formatString, this.expr, this.retryable, data, stack));
                this.exceptionList.add(eee);
                this.code = null;
                this.w3cCode = null;
                this.message = null;
                this.formatString = null;
                this.retryable = false;
                this.xqueryVersionStack.clear();
                this.dataList.clear();
                this.stackList.clear();
                return;
            }
            if (localName.equals("expr")) {
                this.expr = this.sb.toString();
            }
            if (localName.equals("format-string")) {
                this.formatString = this.sb.toString();
            }
            if (localName.equals("frame")) {
                XdmVariable[] variables = null;
                variables = this.variablesList.toArray(new XdmVariable[this.variablesList.size()]);
                this.stackList.add(new QueryStackFrame(this.uri, this.line, this.operation, variables, this.contextItem, this.contextPosition, this.xqueryVersion));
                this.uri = null;
                this.line = 0;
                this.operation = null;
                this.variablesList.clear();
                this.xqueryVersion = this.xqueryVersionStack.removeLast();
                this.contextItem = null;
                this.contextPosition = 0;
            }
            if (localName.equals("line")) {
                this.line = Integer.parseInt(this.sb.toString());
            }
            if (localName.equals("message")) {
                this.message = this.sb.toString();
            }
            if (localName.equals("name")) {
                this.name = this.sb.toString();
            }
            if (localName.equals("operation")) {
                this.operation = this.sb.toString();
            }
            if (localName.equals("retryable")) {
                this.retryable = this.sb.toString().equals("true");
            }
            if (localName.equals("title")) {
                this.exceptionList.add(new RequestServerException(this.sb.toString(), this.request));
            }
            if (localName.equals("uri")) {
                this.uri = this.sb.toString();
            }
            if (localName.equals("value")) {
                this.value = this.sb.toString();
            }
            if (localName.equals("variable")) {
                if (this.variablesList != null) {
                    ValueFactory.newVariable(new XName(this.name), ValueFactory.newXSString(this.value));
                }
                this.name = null;
                this.value = null;
            }
            this.sb.setLength(0);
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void warning(SAXParseException e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            this.exceptionList.add(new RequestServerException("ErrorParser: SAX warning: " + message, this.request, e));
        }

        @Override
        public void error(SAXParseException e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            this.exceptionList.add(new RequestServerException("ErrorParser: SAX error: " + message, this.request, e));
        }

        @Override
        public void fatalError(SAXParseException e) {
        }
    }
}

