/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.exceptions;

import com.marklogic.xcc.Request;
import com.marklogic.xcc.Version;
import com.marklogic.xcc.exceptions.XccException;
import com.marklogic.xcc.impl.SessionImpl;

public class RequestException
extends XccException {
    private static final long serialVersionUID = -7193834172330203276L;
    private transient Request request;

    public RequestException(String message, Request request) {
        super(message);
        this.request = request;
    }

    public RequestException(String message, Request request, Throwable cause) {
        super(message, cause);
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        this.appendRequestInfo(sb);
        return sb.toString();
    }

    protected void appendRequestInfo(StringBuffer sb) {
        String nl = System.getProperty("line.separator");
        String serverVersion = ((SessionImpl)this.request.getSession()).getServerVersion();
        sb.append(nl);
        sb.append(" [Session: ");
        sb.append(this.request.getSession().toString());
        sb.append("]");
        sb.append(nl);
        sb.append(" [Client: XCC/");
        sb.append(Version.getVersionString());
        if (serverVersion != null) {
            sb.append(", Server: XDBC/");
            sb.append(serverVersion);
        }
        sb.append("]");
    }
}

