/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.RequestPermissionException;
import com.marklogic.xcc.exceptions.RequestServerException;
import com.marklogic.xcc.exceptions.RetryableQueryException;
import com.marklogic.xcc.exceptions.ServerConnectionException;
import com.marklogic.xcc.exceptions.ServerResponseException;
import com.marklogic.xcc.exceptions.UnexpectedResponseException;
import com.marklogic.xcc.impl.ContentSourceImpl;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.impl.handlers.HttpRequestController;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import com.marklogic.xcc.spi.ConnectionErrorAction;
import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.ServerConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRequestController
implements HttpRequestController {
    protected final Map<Integer, ResponseHandler> handlers;
    protected static final Integer DEFAULT_HANDLER_KEY = new Integer(0);
    public static boolean dontSleep = false;

    protected AbstractRequestController(Map<Integer, ResponseHandler> handlers) {
        this.handlers = handlers == null ? new HashMap<Integer, ResponseHandler>() : handlers;
    }

    public abstract ResultSequence serverDialog(ServerConnection var1, Request var2, RequestOptions var3, Logger var4) throws IOException, RequestException;

    @Override
    public ResultSequence runRequest(ConnectionProvider provider, Request request, Logger logger) throws RequestException {
        int t;
        SessionImpl session = (SessionImpl)request.getSession();
        RequestOptions options = request.getEffectiveOptions();
        long delayMillis = options.getAutoRetryDelayMillis();
        int retries = options.getMaxAutoRetry();
        int tries = Math.max(retries + 1, 1);
        RequestException re = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("submitting request, max tries=" + tries);
        }
        for (t = 0; t < tries; ++t) {
            block26: {
                ServerConnection connection = null;
                this.sleepFor(this.interTryDelay(delayMillis, t));
                try {
                    while (true) {
                        connection = provider.obtainConnection(session, request, logger);
                        try {
                            ResultSequence rs = this.serverDialog(connection, request, options, logger);
                            if (rs == null || rs.isCached()) {
                                provider.returnConnection(connection, logger);
                            }
                            return rs;
                        }
                        catch (RequestPermissionException e) {
                            if (e.isRetryAdvised()) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "Retryable permission exception caught.", e);
                                }
                                provider.returnConnection(connection, logger);
                                continue;
                            }
                            provider.returnConnection(connection, logger);
                            throw e;
                        }
                        break;
                    }
                }
                catch (RetryableQueryException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Retryable server exception caught.", e);
                    }
                    provider.returnConnection(connection, logger);
                    re = e;
                }
                catch (ServerResponseException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "ServerResponseException caught.", e);
                    }
                    provider.returnConnection(connection, logger);
                    throw e;
                }
                catch (ServerConnectionException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Retryable server exception caught.", e);
                    }
                    provider.returnConnection(connection, logger);
                    re = e;
                }
                catch (RequestServerException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Non-retryable server exception caught.", e);
                    }
                    provider.returnConnection(connection, logger);
                    throw e;
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Connection IOException caught.", e);
                    }
                    ConnectionErrorAction action = null;
                    if (connection != null) {
                        action = provider.returnErrorConnection(connection, e, logger);
                    }
                    re = new ServerConnectionException(e.getMessage(), request, e);
                    boolean badResponse = e.getCause() instanceof UnexpectedResponseException;
                    if (badResponse) {
                        logger.log(Level.WARNING, e.getMessage());
                    }
                    if (action == ConnectionErrorAction.RETRY || badResponse) break block26;
                    if (action == null) {
                        logger.log(Level.WARNING, "Cannot obtain connection: " + e.getMessage(), e);
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Provider error action=" + action + ", throwing: " + re, re);
                    }
                    throw re;
                }
            }
            if (session.getTxnID() != null || session.getTransactionMode() == null || session.getTransactionMode().isRetryable()) continue;
            if (re == null || re.getCause() instanceof UnexpectedResponseException) break;
            throw re;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "automatic query retries (" + t + ") exhausted, throwing: " + re, re);
        }
        if (re != null) {
            throw re;
        }
        String msg = "BAD INTERNAL STATE: retries exhausted, no prior retryable exception";
        logger.severe(msg);
        throw new RequestException(msg, request);
    }

    protected void addHandler(int code, ResponseHandler handler) {
        AbstractRequestController.addHandler(this.handlers, code, handler);
    }

    protected static void addHandler(Map<Integer, ResponseHandler> handlers, int code, ResponseHandler handler) {
        handlers.put(new Integer(code), handler);
    }

    protected void addDefaultHandler(ResponseHandler handler) {
        AbstractRequestController.addDefaultHandler(this.handlers, handler);
    }

    protected static void addDefaultHandler(Map<Integer, ResponseHandler> handlers, ResponseHandler handler) {
        handlers.put(DEFAULT_HANDLER_KEY, handler);
    }

    protected ResponseHandler findHandler(int responseCode) {
        ResponseHandler handler = this.handlers.get(new Integer(responseCode));
        if (handler != null) {
            return handler;
        }
        return this.handlers.get(DEFAULT_HANDLER_KEY);
    }

    protected abstract long interTryDelay(long var1, int var3);

    private void sleepFor(long millis) {
        long now;
        if (dontSleep || millis <= 0L) {
            return;
        }
        long wakeupTime = System.currentTimeMillis() + millis;
        while ((now = System.currentTimeMillis()) < wakeupTime) {
            long sleepTime = wakeupTime - now;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {}
        }
    }

    protected void setConnectionTimeout(ServerConnection connection, HttpChannel http) {
        long expiryTime = 0L;
        try {
            expiryTime = http.getResponseKeepaliveExpireTime();
        }
        catch (IOException e) {
            // empty catch block
        }
        connection.setTimeoutTime(expiryTime);
    }

    protected void addCommonHeaders(HttpChannel http, SessionImpl session, String method, String uri, RequestOptions options, Logger logger) {
        ContentSourceImpl contentSource = (ContentSourceImpl)session.getContentSource();
        String authorization = contentSource.getAuthString(method, uri, session.getUserCredentials());
        if (authorization != null) {
            http.setRequestHeader("Authorization", authorization);
        }
        http.setRequestHeader("User-Agent", session.userAgentString());
        http.setRequestHeader("Accept", session.getAcceptedContentTypes());
        if (HttpChannel.isUseHTTP()) {
            ConnectionProvider cp = contentSource.getConnectionProvider();
            http.setRequestHeader("Host", cp.getHostName() + ":" + cp.getPort());
        }
        if (options.getRequestName() != null) {
            http.setRequestHeader("Referer", options.getRequestName());
        }
        if (session.getSessionID() != null) {
            http.setRequestHeader("Cookie", "SessionID=" + session.getSessionID());
            logger.fine("Sending SessionID: " + session.getSessionID() + ", TxnID: " + session.getTxnID() + ", TxnMode: " + (Object)((Object)session.getTransactionMode()));
        }
    }
}

