/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.CtsBox;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.impl.AbstractStringItem;

public class CtsBoxImpl
extends AbstractStringItem
implements CtsBox {
    private String south;
    private String west;
    private String north;
    private String east;

    public CtsBoxImpl(String value) {
        super(ValueType.CTS_BOX, value);
    }

    public CtsBoxImpl(String south, String west, String north, String east) {
        super(ValueType.CTS_BOX, null);
        this.south = south;
        this.west = west;
        this.north = north;
        this.east = east;
    }

    private void parse() {
        try {
            int i = this.value.indexOf(44, 1);
            this.south = this.value.substring(1, i);
            int j = this.value.indexOf(44, i += 2);
            this.west = this.value.substring(i, j);
            i = this.value.indexOf(44, j += 2);
            this.north = this.value.substring(j, i);
            j = this.value.indexOf(93, i += 2);
            this.east = this.value.substring(i, j);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse value as cts:box: " + this.value);
        }
    }

    @Override
    public String asString() {
        if (this.value == null) {
            this.value = String.format("[%s, %s, %s, %s]", this.south, this.west, this.north, this.east);
        }
        return this.value;
    }

    @Override
    public String getSouth() {
        if (this.south == null) {
            this.parse();
        }
        return this.south;
    }

    @Override
    public String getWest() {
        if (this.west == null) {
            this.parse();
        }
        return this.west;
    }

    @Override
    public String getNorth() {
        if (this.north == null) {
            this.parse();
        }
        return this.north;
    }

    @Override
    public String getEast() {
        if (this.east == null) {
            this.parse();
        }
        return this.east;
    }
}

