/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.io.SslByteChannel;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.impl.SSLSocketPoolProvider;
import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.ServerConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLConnection
implements ServerConnection {
    private final ServerConnection plainConn;
    private final ConnectionProvider provider;
    private final ByteChannel sslChannel;

    public SSLConnection(ServerConnection conn, SecurityOptions securityOptions, SSLSocketPoolProvider provider, Logger logger) throws IOException {
        String[] ciphers;
        if (!(conn.channel() instanceof SocketChannel)) {
            throw new IllegalArgumentException("Underlying channel is not a SocketChannel");
        }
        InetSocketAddress addr = provider.getAddress();
        SSLContext context = securityOptions.getSslContext();
        SSLEngine sslEngine = context.createSSLEngine(addr.getHostName(), addr.getPort());
        this.plainConn = conn;
        this.provider = provider;
        sslEngine.setUseClientMode(true);
        String[] protocols = securityOptions.getEnabledProtocols();
        if (protocols != null) {
            sslEngine.setEnabledProtocols(protocols);
        }
        if ((ciphers = securityOptions.getEnabledCipherSuites()) != null) {
            sslEngine.setEnabledCipherSuites(ciphers);
        }
        this.sslChannel = new SslByteChannel(this.plainConn.channel(), sslEngine, logger);
    }

    @Override
    public ByteChannel channel() {
        return this.sslChannel;
    }

    @Override
    public ConnectionProvider provider() {
        return this.provider;
    }

    @Override
    public long getTimeoutMillis() {
        return this.plainConn.getTimeoutMillis();
    }

    @Override
    @Deprecated
    public void setTimeoutMillis(long timeoutMillis) {
        this.plainConn.setTimeoutTime(timeoutMillis);
    }

    @Override
    public long getTimeoutTime() {
        return this.plainConn.getTimeoutTime();
    }

    @Override
    public void setTimeoutTime(long timeMillis) {
        this.plainConn.setTimeoutTime(timeMillis);
    }

    @Override
    public void close() {
        try {
            this.sslChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isOpen() {
        return this.plainConn.isOpen();
    }
}

