/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.storage.marklogic;

import com.marklogic.client.document.DocumentMetadataPatchBuilder;
import com.marklogic.client.document.DocumentPatchBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.dom4j.Element;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.storage.marklogic.MarkLogicHelper;
import org.nuxeo.ecm.storage.marklogic.MarkLogicStateSerializer;

class MarkLogicStateUpdateBuilder
implements Function<State.StateDiff, DocumentMetadataPatchBuilder.PatchHandle> {
    private final Supplier<DocumentPatchBuilder> supplier;

    public MarkLogicStateUpdateBuilder(Supplier<DocumentPatchBuilder> supplier) {
        this.supplier = supplier;
    }

    @Override
    public DocumentMetadataPatchBuilder.PatchHandle apply(State.StateDiff diff) {
        DocumentPatchBuilder patchBuilder = this.supplier.get();
        this.fillPatch(patchBuilder, "/document", diff);
        return patchBuilder.build();
    }

    private void fillPatch(DocumentPatchBuilder patchBuilder, String path, State.StateDiff diff) {
        for (Map.Entry entry : diff.entrySet()) {
            String subPath = path + "/" + MarkLogicHelper.serializeKey((String)entry.getKey());
            Serializable value = (Serializable)entry.getValue();
            if (value instanceof State.StateDiff) {
                this.fillPatch(patchBuilder, subPath, (State.StateDiff)value);
                continue;
            }
            if (value instanceof State.ListDiff) {
                this.fillPatch(patchBuilder, subPath, (State.ListDiff)value);
                continue;
            }
            if (value instanceof Delta && ((Delta)value).getBase() != null) {
                DocumentMetadataPatchBuilder.Call call = patchBuilder.call().add((Number)((Delta)value).getDeltaValue().doubleValue());
                patchBuilder.replaceApply(subPath, DocumentMetadataPatchBuilder.Cardinality.ONE, call);
                continue;
            }
            Optional<Element> fragment = MarkLogicStateSerializer.serialize((String)entry.getKey(), value);
            if (fragment.isPresent()) {
                patchBuilder.replaceInsertFragment(subPath, path, DocumentPatchBuilder.Position.LAST_CHILD, (Object)fragment.get().asXML());
                continue;
            }
            patchBuilder.delete(subPath);
        }
    }

    private void fillPatch(DocumentPatchBuilder patchBuilder, String path, State.ListDiff listDiff) {
        String itemName = MarkLogicHelper.buildItemNameFromPath(path);
        if (listDiff.diff != null) {
            int i = 1;
            for (Object value : listDiff.diff) {
                String subPath = path + '/' + itemName + '[' + i + ']';
                if (value instanceof State.StateDiff) {
                    this.fillPatch(patchBuilder, subPath, (State.StateDiff)value);
                } else if (value != State.NOP) {
                    Optional<Element> fragment = MarkLogicStateSerializer.serialize(itemName, value);
                    if (fragment.isPresent()) {
                        patchBuilder.replaceFragment(subPath, DocumentMetadataPatchBuilder.Cardinality.ONE, (Object)fragment.get().asXML());
                    } else {
                        patchBuilder.delete(subPath);
                    }
                }
                ++i;
            }
        }
        if (listDiff.rpush != null) {
            for (Object value : listDiff.rpush) {
                Element fragment = MarkLogicStateSerializer.serialize(itemName, value).get();
                patchBuilder.insertFragment(path, DocumentPatchBuilder.Position.LAST_CHILD, (Object)fragment.asXML());
            }
        }
    }
}

