/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicInternalException;

public enum Format {
    BINARY,
    JSON,
    TEXT,
    XML,
    UNKNOWN;


    public String getDefaultMimetype() {
        switch (this) {
            case UNKNOWN: {
                return null;
            }
            case BINARY: {
                return "application/octet-stream";
            }
            case JSON: {
                return "application/json";
            }
            case TEXT: {
                return "text/plain";
            }
            case XML: {
                return "application/xml";
            }
        }
        throw new MarkLogicInternalException("Unknown format " + this.toString());
    }

    public static Format getFromMimetype(String mimeType) {
        if (mimeType == null) {
            return UNKNOWN;
        }
        if ("application/xml".equals(mimeType)) {
            return XML;
        }
        if ("text/xml".equals(mimeType)) {
            return XML;
        }
        if ("application/json".equals(mimeType)) {
            return JSON;
        }
        if ("text/xml".equals(mimeType)) {
            return JSON;
        }
        if ("application/octet-stream".equals(mimeType)) {
            return BINARY;
        }
        if (mimeType.startsWith("text/")) {
            return TEXT;
        }
        return UNKNOWN;
    }
}

