/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.MarkLogicInternalException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class ValueConverter {
    private static final BigInteger MIN_UNSIGNED = new BigInteger("0");
    public static final BigInteger MAX_UNSIGNED_LONG = new BigInteger("18446744073709551615");
    public static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    public static final int MAX_UNSIGNED_SHORT = 65535;
    private static DatatypeFactory datatypeFactory;

    private ValueConverter() {
    }

    public static void convertFromJava(Object value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
        } else if (value instanceof BigDecimal) {
            ValueConverter.convertFromJava((BigDecimal)value, processor);
        } else if (value instanceof BigInteger) {
            ValueConverter.convertFromJava((BigInteger)value, processor);
        } else if (value instanceof Boolean) {
            ValueConverter.convertFromJava((Boolean)value, processor);
        } else if (value instanceof Byte) {
            ValueConverter.convertFromJava((Byte)value, processor);
        } else if (value instanceof byte[]) {
            ValueConverter.convertFromJava((byte[])value, processor);
        } else if (value instanceof Calendar) {
            ValueConverter.convertFromJava((Calendar)value, processor);
        } else if (value instanceof Double) {
            ValueConverter.convertFromJava((Double)value, processor);
        } else if (value instanceof Duration) {
            ValueConverter.convertFromJava((Duration)value, processor);
        } else if (value instanceof Float) {
            ValueConverter.convertFromJava((Float)value, processor);
        } else if (value instanceof Integer) {
            ValueConverter.convertFromJava((Integer)value, processor);
        } else if (value instanceof Long) {
            ValueConverter.convertFromJava((Long)value, processor);
        } else if (value instanceof Short) {
            ValueConverter.convertFromJava((Short)value, processor);
        } else if (value instanceof String) {
            ValueConverter.convertFromJava((String)value, processor);
        } else {
            processor.process(value, "xs:anySimpleType", DatatypeConverter.printString((String)value.toString()));
        }
    }

    public static void convertFromJava(BigDecimal value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:decimal", DatatypeConverter.printDecimal((BigDecimal)value));
    }

    public static void convertFromJava(BigInteger value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        if (MIN_UNSIGNED.compareTo(value) <= 0 && MAX_UNSIGNED_LONG.compareTo(value) >= 0) {
            processor.process(value, "xs:unsignedLong", DatatypeConverter.printInteger((BigInteger)value));
        } else {
            processor.process(value, "xs:integer", DatatypeConverter.printInteger((BigInteger)value));
        }
    }

    public static void convertFromJava(Boolean value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:boolean", DatatypeConverter.printBoolean((boolean)value));
    }

    public static void convertFromJava(Byte value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:byte", DatatypeConverter.printByte((byte)value));
    }

    public static void convertFromJava(byte[] value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:base64Binary", DatatypeConverter.printBase64Binary((byte[])value));
    }

    public static void convertFromJava(Calendar value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        if (!value.isSet(5)) {
            processor.process(value, "xs:time", DatatypeConverter.printTime((Calendar)value));
        } else if (value.isSet(11)) {
            processor.process(value, "xs:dateTime", DatatypeConverter.printDateTime((Calendar)value));
        } else {
            processor.process(value, "xs:date", DatatypeConverter.printDate((Calendar)value));
        }
    }

    public static void convertFromJava(Double value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:double", DatatypeConverter.printDouble((double)value));
    }

    public static void convertFromJava(Duration value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:" + value.getXMLSchemaType().getLocalPart(), value.toString());
    }

    public static void convertFromJava(Float value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:float", DatatypeConverter.printFloat((float)value.floatValue()));
    }

    public static void convertFromJava(Integer value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        int ival = value;
        if (0 <= ival && ival <= 65535) {
            processor.process(value, "xs:unsignedShort", DatatypeConverter.printUnsignedShort((int)ival));
        } else {
            processor.process(value, "xs:int", DatatypeConverter.printInt((int)ival));
        }
    }

    public static void convertFromJava(Long value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        long longVal = value;
        if (0L <= longVal && longVal <= 0xFFFFFFFFL) {
            processor.process(value, "xs:unsignedInt", DatatypeConverter.printUnsignedInt((long)longVal));
        } else {
            processor.process(value, "xs:long", DatatypeConverter.printLong((long)longVal));
        }
    }

    public static void convertFromJava(Short value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:short", DatatypeConverter.printShort((short)value));
    }

    public static void convertFromJava(String value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:string", DatatypeConverter.printString((String)value));
    }

    public static Object convertToJava(String type, String value) {
        if ("xs:anySimpleType".equals(type)) {
            return DatatypeConverter.parseAnySimpleType((String)value);
        }
        if ("xs:base64Binary".equals(type)) {
            return DatatypeConverter.parseBase64Binary((String)value);
        }
        if ("xs:boolean".equals(type)) {
            return DatatypeConverter.parseBoolean((String)value);
        }
        if ("xs:byte".equals(type)) {
            return DatatypeConverter.parseByte((String)value);
        }
        if ("xs:date".equals(type)) {
            return DatatypeConverter.parseDate((String)value);
        }
        if ("xs:dateTime".equals(type)) {
            return DatatypeConverter.parseDateTime((String)value);
        }
        if ("xs:dayTimeDuration".equals(type)) {
            return ValueConverter.getFactory().newDurationDayTime(value);
        }
        if ("xs:decimal".equals(type)) {
            return DatatypeConverter.parseDecimal((String)value);
        }
        if ("xs:double".equals(type)) {
            return DatatypeConverter.parseDouble((String)value);
        }
        if ("xs:duration".equals(type)) {
            return ValueConverter.getFactory().newDuration(value);
        }
        if ("xs:float".equals(type)) {
            return Float.valueOf(DatatypeConverter.parseFloat((String)value));
        }
        if ("xs:int".equals(type)) {
            return DatatypeConverter.parseInt((String)value);
        }
        if ("xs:integer".equals(type)) {
            return DatatypeConverter.parseInteger((String)value);
        }
        if ("xs:long".equals(type)) {
            return DatatypeConverter.parseLong((String)value);
        }
        if ("xs:short".equals(type)) {
            return DatatypeConverter.parseShort((String)value);
        }
        if ("xs:string".equals(type)) {
            return DatatypeConverter.parseString((String)value);
        }
        if ("xs:time".equals(type)) {
            return DatatypeConverter.parseTime((String)value);
        }
        if ("xs:unsignedInt".equals(type)) {
            return DatatypeConverter.parseUnsignedInt((String)value);
        }
        if ("xs:unsignedLong".equals(type)) {
            BigInteger bi = DatatypeConverter.parseInteger((String)value);
            if (bi.compareTo(MAX_UNSIGNED_LONG) < 0) {
                return bi.longValue();
            }
            return bi;
        }
        if ("xs:unsignedShort".equals(type)) {
            return DatatypeConverter.parseUnsignedShort((String)value);
        }
        if ("xs:yearMonthDuration".equals(type)) {
            return ValueConverter.getFactory().newDurationYearMonth(value);
        }
        return value;
    }

    public static <T> T convertToJava(String type, String value, Class<T> as) {
        return (T)ValueConverter.convertToJava(type, value);
    }

    private static DatatypeFactory getFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new MarkLogicInternalException(e);
            }
        }
        return datatypeFactory;
    }

    public static interface ValueProcessor {
        public void process(Object var1, String var2, String var3);
    }
}

