/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.OutputStreamTee;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.util.RequestLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.ws.rs.core.StreamingOutput;

class StreamingOutputImpl
implements StreamingOutput {
    private OutputStreamSender handle;
    private RequestLogger logger;

    StreamingOutputImpl(OutputStreamSender handle, RequestLogger logger) {
        this.handle = handle;
        this.logger = logger;
    }

    public void write(OutputStream out) throws IOException {
        if (this.logger != null) {
            PrintStream tee = this.logger.getPrintStream();
            long max = this.logger.getContentMax();
            if (tee != null && max > 0L) {
                this.handle.write(new OutputStreamTee(out, tee, max));
                return;
            }
        }
        this.handle.write(out);
    }
}

