/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.SPARQLBindingImpl;
import com.marklogic.client.semantics.RDFTypes;
import com.marklogic.client.semantics.SPARQLBinding;
import com.marklogic.client.semantics.SPARQLBindings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;

public class SPARQLBindingsImpl
extends TreeMap<String, List<SPARQLBinding>>
implements SPARQLBindings {
    @Override
    public SPARQLBindings bind(String name, String value) {
        return this.bind(name, value, (RDFTypes)null);
    }

    @Override
    public SPARQLBindings bind(String name, String value, RDFTypes type) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.add(new SPARQLBindingImpl(name, value, type));
        return this;
    }

    @Override
    public SPARQLBindings bind(String name, String value, Locale languageTag) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.add(new SPARQLBindingImpl(name, value, languageTag));
        return this;
    }

    private void add(SPARQLBinding binding) {
        String name = binding.getName();
        ArrayList<SPARQLBinding> bindings = (ArrayList<SPARQLBinding>)this.get(name);
        if (bindings == null) {
            bindings = new ArrayList<SPARQLBinding>();
        }
        bindings.add(binding);
        this.put(name, bindings);
    }
}

