/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.storage.marklogic;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.DateTime;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.storage.marklogic.MarkLogicHelper;

final class MarkLogicStateSerializer {
    private MarkLogicStateSerializer() {
    }

    public static String serialize(State state) {
        Element root = MarkLogicStateSerializer.serialize("document", state);
        MarkLogicStateSerializer.addDefaultNamespaces(root);
        return DocumentHelper.createDocument((Element)root).asXML();
    }

    private static Element serialize(String key, State state) {
        Element element = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey(key));
        for (Map.Entry entry : state.entrySet()) {
            MarkLogicStateSerializer.serialize((String)entry.getKey(), entry.getValue()).ifPresent(arg_0 -> ((Element)element).add(arg_0));
        }
        return element;
    }

    public static Optional<Element> serialize(String key, Object value) {
        Optional<Object> result;
        if (value == null) {
            result = Optional.empty();
        } else if (value instanceof State) {
            State state = (State)value;
            result = state.isEmpty() ? Optional.empty() : Optional.of(MarkLogicStateSerializer.serialize(key, state));
        } else if (value instanceof List) {
            List values = (List)value;
            result = values.isEmpty() ? Optional.empty() : Optional.of(MarkLogicStateSerializer.serialize(key, values));
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            result = array.length == 0 ? Optional.empty() : Optional.of(MarkLogicStateSerializer.serialize(key, Arrays.asList(array)));
        } else {
            String nodeValue = MarkLogicStateSerializer.serializeValue(value);
            Element element = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey(key));
            element.addAttribute("xsi:type", MarkLogicHelper.ElementType.getType(value.getClass()).getKey());
            element.setText(nodeValue);
            result = Optional.of(element);
        }
        return result;
    }

    private static Element serialize(String key, List<Object> list) {
        Element array = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey(key));
        for (Object object : list) {
            MarkLogicStateSerializer.serialize(key + "__item", object).ifPresent(arg_0 -> ((Element)array).add(arg_0));
        }
        return array;
    }

    public static String serializeValue(Object value) {
        String serializedValue = value instanceof Calendar ? MarkLogicHelper.serializeCalendar((Calendar)value) : (value instanceof DateTime ? ((DateTime)value).toString(MarkLogicHelper.DATE_TIME_FORMATTER) : value.toString());
        return serializedValue;
    }

    public static void addDefaultNamespaces(Element root) {
        root.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        root.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }
}

