/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.util;

import com.marklogic.client.util.IterableNamespaceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EditableNamespaceContext
implements IterableNamespaceContext,
Map<String, String> {
    private HashMap<String, String> bindings = new HashMap();

    public String getDefaultNamespaceURI() {
        return this.bindings.get("");
    }

    public void setDefaultNamespaceURI(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Cannot set default prefix to null namespace URI");
        }
        this.bindings.put("", namespaceURI);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot get namespace URI for null prefix");
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String namespaceURI = this.bindings.get(prefix);
        return namespaceURI != null ? namespaceURI : "";
    }

    public void setNamespaceURI(String prefix, String namespaceURI) {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot bind null prefix");
        }
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Cannot set prefix to null namespace URI");
        }
        if ("xml".equals(prefix) || "xmlns".equals(prefix)) {
            return;
        }
        this.bindings.put(prefix, namespaceURI);
    }

    @Override
    public Collection<String> getAllPrefixes() {
        return this.bindings.keySet();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Cannot find prefix for null namespace URI");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        for (Map.Entry<String, String> entry : this.bindings.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Cannot find prefix for null namespace URI");
        }
        ArrayList<String> list = new ArrayList<String>();
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            list.add("xml");
        } else if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            list.add("xmlns");
        } else {
            for (Map.Entry<String, String> entry : this.bindings.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                list.add(entry.getKey());
            }
        }
        return Collections.unmodifiableList(list).iterator();
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.bindings.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.bindings.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.bindings.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.bindings.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.bindings.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.bindings.putAll(m);
    }

    @Override
    public void clear() {
        this.bindings.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.bindings.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.bindings.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.bindings.entrySet();
    }
}

