/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class Utilities {
    private static DocumentBuilderFactory factory;

    private static DocumentBuilderFactory getFactory() throws ParserConfigurationException {
        if (factory == null) {
            factory = Utilities.makeDocumentBuilderFactory();
        }
        return factory;
    }

    private static DocumentBuilderFactory makeDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        return factory;
    }

    public static Element domElement(String xmlString) {
        Element element = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes(Charset.forName("UTF-8")));
            element = Utilities.getFactory().newDocumentBuilder().parse(bais).getDocumentElement();
        }
        catch (SAXException e) {
            throw new MarkLogicIOException("Could not make Element from xmlString" + xmlString, e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException("Could not make Element from xmlString" + xmlString, e);
        }
        catch (ParserConfigurationException e) {
            throw new MarkLogicIOException("Could not make Element from xmlString" + xmlString, e);
        }
        return element;
    }

    public static List<XMLEvent> importFromHandle(AbstractWriteHandle writeHandle) {
        if (writeHandle == null) {
            return null;
        }
        HandleImplementation baseHandle = HandleAccessor.checkHandle(writeHandle, "import");
        return Utilities.objectToEvents(baseHandle.sendContent());
    }

    public static List<XMLEvent> objectToEvents(Object content) {
        if (content == null) {
            return null;
        }
        if (content instanceof byte[]) {
            return Utilities.bytesToEvents((byte[])content);
        }
        if (content instanceof File) {
            return Utilities.fileToEvents((File)content);
        }
        if (content instanceof InputStream) {
            return Utilities.inputStreamToEvents((InputStream)content);
        }
        if (content instanceof Reader) {
            return Utilities.readerToEvents((Reader)content);
        }
        if (content instanceof String) {
            return Utilities.stringToEvents((String)content);
        }
        if (content instanceof OutputStreamSender) {
            return Utilities.outputSenderToEvents((OutputStreamSender)content);
        }
        throw new IllegalArgumentException("Unrecognized class for import: " + content.getClass().getName());
    }

    public static List<XMLEvent> bytesToEvents(byte[] bytes) {
        return Utilities.readerToEvents(Utilities.readBytes(bytes));
    }

    public static List<XMLEvent> fileToEvents(File file) {
        return Utilities.readerToEvents(Utilities.readFile(file));
    }

    public static List<XMLEvent> inputStreamToEvents(InputStream stream) {
        return Utilities.readerToEvents(Utilities.readInputStream(stream));
    }

    public static List<XMLEvent> outputSenderToEvents(OutputStreamSender sender) {
        return Utilities.readerToEvents(Utilities.readOutputSender(sender));
    }

    public static List<XMLEvent> readerToEvents(Reader reader) {
        return Utilities.readerToEvents(Utilities.readReader(reader));
    }

    public static List<XMLEvent> stringToEvents(String string) {
        return Utilities.readerToEvents(Utilities.readString(string));
    }

    static XMLEventReader readBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return Utilities.readInputStream(new ByteArrayInputStream(bytes));
    }

    static XMLEventReader readFile(File file) {
        try {
            if (file == null) {
                return null;
            }
            return Utilities.readInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new MarkLogicIOException(e);
        }
    }

    static XMLEventReader readInputStream(InputStream stream) {
        try {
            if (stream == null) {
                return null;
            }
            return Utilities.makeInputFactory().createXMLEventReader(stream);
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException(e);
        }
    }

    static XMLEventReader readOutputSender(OutputStreamSender sender) {
        try {
            if (sender == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            sender.write(baos);
            return Utilities.readBytes(baos.toByteArray());
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    static XMLEventReader readReader(Reader reader) {
        try {
            if (reader == null) {
                return null;
            }
            return Utilities.makeInputFactory().createXMLEventReader(reader);
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException(e);
        }
    }

    static XMLEventReader readString(String string) {
        if (string == null) {
            return null;
        }
        return Utilities.readReader(new StringReader(string));
    }

    static XMLInputFactory makeInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        factory.setProperty("javax.xml.stream.isValidating", false);
        return factory;
    }

    public static List<XMLEvent> readerToEvents(XMLEventReader reader) {
        try {
            if (reader == null) {
                return null;
            }
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            block5: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 7: 
                    case 8: {
                        continue block5;
                    }
                }
                events.add(event);
            }
            if (events.size() == 0) {
                return null;
            }
            return events;
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static <T extends AbstractReadHandle> T exportToHandle(List<XMLEvent> events, T handle) {
        if (handle == null) {
            return null;
        }
        HandleImplementation baseHandle = HandleAccessor.checkHandle(handle, "export");
        baseHandle.receiveContent(Utilities.eventsToObject(events, baseHandle.receiveAs()));
        return handle;
    }

    public static Object eventsToObject(List<XMLEvent> events, Class<?> as) {
        if (events == null || events.size() == 0) {
            return null;
        }
        if (byte[].class.isAssignableFrom(as)) {
            return Utilities.eventsToBytes(events);
        }
        if (File.class.isAssignableFrom(as)) {
            return Utilities.eventsToFile(events, ".xml");
        }
        if (InputStream.class.isAssignableFrom(as)) {
            return Utilities.eventsToInputStream(events);
        }
        if (Reader.class.isAssignableFrom(as)) {
            return Utilities.eventsToReader(events);
        }
        if (String.class.isAssignableFrom(as)) {
            return Utilities.eventsToString(events);
        }
        throw new IllegalArgumentException("Unrecognized class for export: " + as.getName());
    }

    public static byte[] eventsToBytes(List<XMLEvent> events) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!Utilities.writeEvents(events, baos)) {
            return null;
        }
        return baos.toByteArray();
    }

    public static File eventsToFile(List<XMLEvent> events, String extension) {
        try {
            File tempFile = File.createTempFile("tmp", extension);
            if (!Utilities.writeEvents(events, new FileOutputStream(tempFile))) {
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                return null;
            }
            return tempFile;
        }
        catch (FileNotFoundException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static InputStream eventsToInputStream(List<XMLEvent> events) {
        byte[] bytes = Utilities.eventsToBytes(events);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static Reader eventsToReader(List<XMLEvent> events) {
        String string = Utilities.eventsToString(events);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public static String eventsToString(List<XMLEvent> events) {
        byte[] bytes = Utilities.eventsToBytes(events);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public static boolean writeEvents(List<XMLEvent> events, OutputStream out) {
        if (events == null || events.size() == 0) {
            return false;
        }
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
            XMLEventWriter eventWriter = factory.createXMLEventWriter(out, "UTF-8");
            for (XMLEvent event : events) {
                eventWriter.add(event);
            }
            eventWriter.flush();
            eventWriter.close();
            return true;
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static <T extends AbstractReadHandle> T exportTextToHandle(List<XMLEvent> events, T handle) {
        if (handle == null) {
            return null;
        }
        HandleImplementation baseHandle = HandleAccessor.checkHandle(handle, "export");
        baseHandle.receiveContent(Utilities.eventTextToObject(events, baseHandle.receiveAs()));
        return handle;
    }

    public static Object eventTextToObject(List<XMLEvent> events, Class<?> as) {
        if (events == null || events.size() == 0) {
            return null;
        }
        if (byte[].class.isAssignableFrom(as)) {
            return Utilities.eventTextToBytes(events);
        }
        if (File.class.isAssignableFrom(as)) {
            return Utilities.eventTextToFile(events, ".txt");
        }
        if (InputStream.class.isAssignableFrom(as)) {
            return Utilities.eventTextToInputStream(events);
        }
        if (Reader.class.isAssignableFrom(as)) {
            return Utilities.eventTextToReader(events);
        }
        if (String.class.isAssignableFrom(as)) {
            return Utilities.eventTextToString(events);
        }
        throw new IllegalArgumentException("Unrecognized class for text export: " + as.getName());
    }

    public static byte[] eventTextToBytes(List<XMLEvent> events) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!Utilities.writeEventText(events, baos)) {
            return null;
        }
        return baos.toByteArray();
    }

    public static File eventTextToFile(List<XMLEvent> events, String extension) {
        try {
            File tempFile = File.createTempFile("tmp", extension);
            if (!Utilities.writeEventText(events, new FileOutputStream(tempFile))) {
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                return null;
            }
            return tempFile;
        }
        catch (FileNotFoundException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static InputStream eventTextToInputStream(List<XMLEvent> events) {
        byte[] bytes = Utilities.eventTextToBytes(events);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static Reader eventTextToReader(List<XMLEvent> events) {
        String string = Utilities.eventTextToString(events);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public static String eventTextToString(List<XMLEvent> events) {
        if (events == null || events.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (XMLEvent event : events) {
            if (!event.isCharacters()) continue;
            buf.append(event.asCharacters().getData());
        }
        return buf.toString();
    }

    public static boolean writeEventText(List<XMLEvent> events, OutputStream out) {
        if (events == null || events.size() == 0) {
            return false;
        }
        try {
            for (XMLEvent event : events) {
                if (!event.isCharacters()) continue;
                out.write(event.asCharacters().getData().getBytes());
            }
            out.flush();
            out.close();
            return true;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static Source handleToSource(XMLWriteHandle handle) {
        try {
            if (handle == null) {
                return null;
            }
            HandleImplementation baseHandle = HandleAccessor.checkHandle(handle, "source");
            Object content = baseHandle.sendContent();
            if (content instanceof byte[]) {
                return new StreamSource(new ByteArrayInputStream((byte[])content));
            }
            if (content instanceof File) {
                return new StreamSource(new FileInputStream((File)content));
            }
            if (content instanceof InputStream) {
                return new StreamSource((InputStream)content);
            }
            if (content instanceof OutputStreamSender) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                ((OutputStreamSender)content).write(buf);
                return new StreamSource(new ByteArrayInputStream(buf.toByteArray()));
            }
            if (content instanceof Reader) {
                return new StreamSource((Reader)content);
            }
            if (content instanceof String) {
                return new StreamSource(new StringReader((String)content));
            }
            throw new IllegalArgumentException("Unrecognized handle for source");
        }
        catch (FileNotFoundException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static XMLEventReader makeEventListReader(List<XMLEvent> events) {
        if (events == null || events.size() == 0) {
            return null;
        }
        return new XMLEventListReader(events);
    }

    public static void setHandleContent(ContentHandle handle, Object content) {
        if (handle == null) {
            return;
        }
        handle.set(content);
    }

    public static void setHandleStructuredFormat(ContentHandle handle, Format format) {
        if (handle == null || format == null) {
            return;
        }
        if (BaseHandle.class.isAssignableFrom(handle.getClass())) {
            Utilities.setHandleStructuredFormat((BaseHandle)((Object)handle), format);
        }
    }

    public static void setHandleStructuredFormat(StructureWriteHandle handle, Format format) {
        if (handle == null || format == null) {
            return;
        }
        if (BaseHandle.class.isAssignableFrom(handle.getClass())) {
            Utilities.setHandleStructuredFormat((BaseHandle)((Object)handle), format);
        }
    }

    private static void setHandleStructuredFormat(BaseHandle handle, Format format) {
        if (format != Format.JSON && format != Format.XML) {
            throw new IllegalArgumentException("Received " + format.name() + " format instead of JSON or XML");
        }
        handle.setFormat(format);
    }

    static class XMLEventListReader
    implements XMLEventReader {
        private List<XMLEvent> events;
        private int curr = -1;

        XMLEventListReader(List<XMLEvent> events) {
            this.events = events;
        }

        @Override
        public Object next() {
            return this.nextEvent();
        }

        @Override
        public void remove() {
            if (!this.hasItem(this.curr)) {
                return;
            }
            this.events.remove(this.curr);
        }

        @Override
        public XMLEvent nextEvent() {
            if (!this.hasNext()) {
                return null;
            }
            return this.events.get(++this.curr);
        }

        @Override
        public boolean hasNext() {
            return this.hasItem(this.curr + 1);
        }

        boolean hasItem(int i) {
            return this.events == null || i < this.events.size();
        }

        @Override
        public XMLEvent peek() {
            int peek = this.curr + 1;
            if (!this.hasItem(peek)) {
                return null;
            }
            return this.events.get(peek);
        }

        @Override
        public String getElementText() throws XMLStreamException {
            if (!this.hasNext() || !this.events.get(this.curr).isStartElement()) {
                throw new XMLStreamException("no start element for text");
            }
            StringBuilder buf = new StringBuilder();
            while (++this.curr < this.events.size()) {
                XMLEvent event = this.events.get(this.curr);
                int eventType = event.getEventType();
                if (eventType == 4 || eventType == 12 || eventType == 6) {
                    buf.append(event.asCharacters().getData());
                    continue;
                }
                if (eventType == 2) break;
                if (eventType != 1) continue;
                throw new XMLStreamException("found subelement instead of text");
            }
            return buf.toString();
        }

        @Override
        public XMLEvent nextTag() throws XMLStreamException {
            if (!this.hasNext()) {
                throw new XMLStreamException("no next tag");
            }
            XMLEvent event = this.events.get(this.curr);
            int eventType = event.getEventType();
            if (eventType != 1 && eventType != 2) {
                throw new XMLStreamException("no start tag for next tag");
            }
            while (++this.curr < this.events.size() && (eventType = (event = this.events.get(this.curr)).getEventType()) != 1 && eventType != 2) {
                if (eventType == 6) continue;
                throw new XMLStreamException("event other than space before next tag");
            }
            return event;
        }

        @Override
        public Object getProperty(String name) {
            if (name == null) {
                return null;
            }
            if ("javax.xml.stream.isValidating".equals(name)) {
                return false;
            }
            if ("javax.xml.stream.isNamespaceAware".equals(name)) {
                return true;
            }
            if ("javax.xml.stream.isCoalescing".equals(name)) {
                return false;
            }
            if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
                return false;
            }
            if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
                return false;
            }
            if ("javax.xml.stream.supportDTD".equals(name)) {
                return false;
            }
            return null;
        }

        @Override
        public void close() {
            this.events = null;
            this.curr = -1;
        }
    }
}

