/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.admin.NamespacesManager;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.util.EditableNamespaceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class NamespacesManagerImpl
extends AbstractLoggingManager
implements NamespacesManager {
    private static final Logger logger = LoggerFactory.getLogger(NamespacesManagerImpl.class);
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("<([^: >]+:)?uri(\\s[^>]+)?>([^<>]+)</([^: >]+:)?uri>");
    private RESTServices services;

    NamespacesManagerImpl(RESTServices services) {
        this.services = services;
    }

    @Override
    public String readPrefix(String prefix) throws ForbiddenUserException, FailedRequestException {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot read namespace for null prefix");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Server does not maintain a default namespace");
        }
        String binding = this.services.getValue(this.requestLogger, "config/namespaces", prefix, true, "application/xml", String.class);
        if (binding == null) {
            return null;
        }
        Matcher matcher = NAMESPACE_PATTERN.matcher(binding);
        if (!matcher.find()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to extract namespace from {}", (Object)binding);
            }
            return null;
        }
        return matcher.toMatchResult().group(3);
    }

    @Override
    public NamespaceContext readAll() throws ForbiddenUserException, FailedRequestException {
        EditableNamespaceContext context = new EditableNamespaceContext();
        try {
            InputStream stream = this.services.getValues(this.requestLogger, "config/namespaces", "application/xml", InputStream.class);
            if (stream == null) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().parse(stream);
            NodeList bindings = document.getElementsByTagNameNS("http://marklogic.com/rest-api", "namespace");
            if (bindings == null) {
                return null;
            }
            int bindingsCount = bindings.getLength();
            if (bindingsCount < 1) {
                return null;
            }
            for (int i = 0; i < bindingsCount; ++i) {
                Node binding = bindings.item(i);
                NodeList children = binding.getChildNodes();
                if (children == null) continue;
                String prefix = null;
                String namespaceUri = null;
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (child.getNodeType() != 1) continue;
                    Element element = (Element)child;
                    if ("prefix".equals(element.getLocalName())) {
                        prefix = element.getTextContent();
                        continue;
                    }
                    if (!"uri".equals(element.getLocalName())) continue;
                    namespaceUri = element.getTextContent();
                }
                if (prefix == null || namespaceUri == null) continue;
                context.put(prefix, namespaceUri);
            }
        }
        catch (SAXException e) {
            logger.error("Failed to parse DOM document for namespace bindings", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (IOException e) {
            logger.error("Failed to parse DOM document for namespace bindings", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Failed to parse DOM document for namespace bindings", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        return context;
    }

    @Override
    public void addPrefix(String prefix, String namespaceUri) throws ForbiddenUserException, FailedRequestException {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot write binding for null prefix");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Cannot specify a default namespace");
        }
        if (namespaceUri == null) {
            throw new IllegalArgumentException("Cannot write binding for null namespaceUri");
        }
        String structure = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<namespace-bindings xmlns=\"http://marklogic.com/rest-api\"><namespace>\n    <prefix>" + prefix + "</prefix>\n" + "    <uri>" + namespaceUri + "</uri>\n" + "</namespace>\n" + "</namespace-bindings>";
        this.services.postValue(this.requestLogger, "config/namespaces", prefix, "application/xml", structure);
    }

    @Override
    public void updatePrefix(String prefix, String namespaceUri) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot write binding for null prefix");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Cannot specify a default namespace");
        }
        if (namespaceUri == null) {
            throw new IllegalArgumentException("Cannot write binding for null namespaceUri");
        }
        String structure = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<namespace xmlns=\"http://marklogic.com/rest-api\">\n    <prefix>" + prefix + "</prefix>\n" + "    <uri>" + namespaceUri + "</uri>\n" + "</namespace>\n";
        this.services.putValue(this.requestLogger, "config/namespaces", prefix, "application/xml", structure);
    }

    @Override
    public void deletePrefix(String prefix) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot delete binding for null prefix");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Server does not maintain a default namespace");
        }
        this.services.deleteValue(this.requestLogger, "config/namespaces", prefix);
    }

    @Override
    public void deleteAll() throws ForbiddenUserException, FailedRequestException {
        this.services.deleteValues(this.requestLogger, "config/namespaces");
    }
}

