/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamTee
extends InputStream {
    private InputStream in;
    private OutputStream tee;
    private long max = 0L;
    private long sent = 0L;

    public InputStreamTee(InputStream in, OutputStream tee, long max) {
        this.in = in;
        this.tee = tee;
        this.max = max;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.sent >= this.max) {
            return this.in.read();
        }
        int b = this.in.read();
        if (b == -1) {
            this.cleanupTee();
            return b;
        }
        if (this.max == Long.MAX_VALUE) {
            this.tee.write(b);
            return b;
        }
        this.tee.write(b);
        ++this.sent;
        if (this.sent == this.max) {
            this.cleanupTee();
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.sent >= this.max) {
            return this.in.read(b);
        }
        return this.readTee(b, 0, this.in.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.sent >= this.max) {
            return this.in.read(b, off, len);
        }
        return this.readTee(b, 0, this.in.read(b, off, len));
    }

    private int readTee(byte[] b, int off, int resultLen) throws IOException {
        if (resultLen < 1) {
            if (resultLen == -1) {
                this.cleanupTee();
            }
            return resultLen;
        }
        if (this.max == Long.MAX_VALUE) {
            this.tee.write(b, off, resultLen);
            return resultLen;
        }
        int teeLen = this.sent + (long)resultLen <= this.max ? resultLen : (int)(this.max - this.sent);
        this.sent += (long)teeLen;
        this.tee.write(b, off, teeLen);
        if (this.sent >= this.max) {
            this.cleanupTee();
        }
        return resultLen;
    }

    private void cleanupTee() throws IOException {
        if (this.tee == null) {
            return;
        }
        this.tee.flush();
        this.tee = null;
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.cleanupTee();
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        if (this.in == null) {
            return false;
        }
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.in == null) {
            return;
        }
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("Input Stream closed");
        }
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.in == null) {
            throw new IOException("Input Stream closed");
        }
        return this.in.skip(n);
    }
}

