/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRecordImpl
implements DocumentRecord {
    private static final Logger logger = LoggerFactory.getLogger(DocumentRecordImpl.class);
    private String uri;
    private Format format;
    private String mimetype;
    private InputStream metadata;
    private InputStream content;

    DocumentRecordImpl(String uri, Format format, String mimetype, InputStream metadata, InputStream content) {
        this.uri = uri;
        this.format = format;
        this.mimetype = mimetype;
        this.metadata = metadata;
        this.content = content;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public String getMimetype() {
        return this.mimetype;
    }

    @Override
    public <T extends DocumentMetadataReadHandle> T getMetadata(T metadataHandle) {
        HandleImplementation metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata");
        Format metadataFormat = metadataBase.getFormat();
        if (metadataFormat == null || metadataFormat != Format.XML) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unsupported metadata format {}, using XML", (Object)metadataFormat.name());
            }
            metadataBase.setFormat(Format.XML);
        }
        HandleAccessor.receiveContent(metadataHandle, this.metadata);
        return metadataHandle;
    }

    @Override
    public <T> T getMetadataAs(Class<T> clazz) {
        ContentHandle<T> readHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(clazz);
        if (readHandle instanceof DocumentMetadataReadHandle) {
            DocumentMetadataReadHandle metadataHandle = (DocumentMetadataReadHandle)((Object)readHandle);
            if ((metadataHandle = this.getMetadata(metadataHandle)) == null) {
                return null;
            }
            return readHandle.get();
        }
        throw new IllegalArgumentException("Class \"" + clazz.getName() + "\" uses handle " + readHandle.getClass() + " which is not a DocumentMetadataReadHandle");
    }

    @Override
    public <T extends AbstractReadHandle> T getContent(T contentHandle) {
        HandleAccessor.checkHandle(contentHandle, "content");
        HandleAccessor.receiveContent(contentHandle, this.content);
        return contentHandle;
    }

    @Override
    public <T> T getContentAs(Class<T> clazz) {
        ContentHandle<T> readHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(clazz);
        if ((readHandle = this.getContent(readHandle)) == null) {
            return null;
        }
        return readHandle.get();
    }
}

