/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.MemberProfile;
import com.dropbox.core.v2.team.TeamMemberStatus;
import com.dropbox.core.v2.team.TeamMembershipType;
import com.dropbox.core.v2.users.Name;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class TeamMemberProfile
extends MemberProfile {
    protected final List<String> groups;

    public TeamMemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType, List<String> groups, String externalId, String accountId) {
        super(teamMemberId, email, emailVerified, status, name, membershipType, externalId, accountId);
        if (groups == null) {
            throw new IllegalArgumentException("Required value for 'groups' is null");
        }
        for (String x : groups) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'groups' is null");
        }
        this.groups = groups;
    }

    public TeamMemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType, List<String> groups) {
        this(teamMemberId, email, emailVerified, status, name, membershipType, groups, null, null);
    }

    @Override
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean getEmailVerified() {
        return this.emailVerified;
    }

    @Override
    public TeamMemberStatus getStatus() {
        return this.status;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public TeamMembershipType getMembershipType() {
        return this.membershipType;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    public static Builder newBuilder(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType, List<String> groups) {
        return new Builder(teamMemberId, email, emailVerified, status, name, membershipType, groups);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groups});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamMemberProfile other = (TeamMemberProfile)obj;
            return !(this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.status != other.status && !this.status.equals(other.status) || this.name != other.name && !this.name.equals(other.name) || this.membershipType != other.membershipType && !this.membershipType.equals((Object)other.membershipType) || this.groups != other.groups && !this.groups.equals(other.groups) || this.externalId != other.externalId && (this.externalId == null || !this.externalId.equals(other.externalId)) || this.accountId != other.accountId && (this.accountId == null || !this.accountId.equals(other.accountId)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamMemberProfile> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamMemberProfile value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_member_id");
            StoneSerializers.string().serialize(value.teamMemberId, g);
            g.writeFieldName("email");
            StoneSerializers.string().serialize(value.email, g);
            g.writeFieldName("email_verified");
            StoneSerializers.boolean_().serialize((Boolean)value.emailVerified, g);
            g.writeFieldName("status");
            TeamMemberStatus.Serializer.INSTANCE.serialize(value.status, g);
            g.writeFieldName("name");
            Name.Serializer.INSTANCE.serialize(value.name, g);
            g.writeFieldName("membership_type");
            TeamMembershipType.Serializer.INSTANCE.serialize(value.membershipType, g);
            g.writeFieldName("groups");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.groups, g);
            if (value.externalId != null) {
                g.writeFieldName("external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.externalId, g);
            }
            if (value.accountId != null) {
                g.writeFieldName("account_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.accountId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamMemberProfile deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_accountId;
            String f_externalId;
            List<String> f_groups;
            TeamMembershipType f_membershipType;
            Name f_name;
            TeamMemberStatus f_status;
            Boolean f_emailVerified;
            String f_email;
            String f_teamMemberId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamMemberId = null;
                f_email = null;
                f_emailVerified = null;
                f_status = null;
                f_name = null;
                f_membershipType = null;
                f_groups = null;
                f_externalId = null;
                f_accountId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email_verified".equals(field)) {
                        f_emailVerified = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("status".equals(field)) {
                        f_status = TeamMemberStatus.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = (Name)Name.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("membership_type".equals(field)) {
                        f_membershipType = TeamMembershipType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("groups".equals(field)) {
                        f_groups = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("external_id".equals(field)) {
                        f_externalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamMemberId == null) {
                    throw new JsonParseException(p, "Required field \"team_member_id\" missing.");
                }
                if (f_email == null) {
                    throw new JsonParseException(p, "Required field \"email\" missing.");
                }
                if (f_emailVerified == null) {
                    throw new JsonParseException(p, "Required field \"email_verified\" missing.");
                }
                if (f_status == null) {
                    throw new JsonParseException(p, "Required field \"status\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_membershipType == null) {
                    throw new JsonParseException(p, "Required field \"membership_type\" missing.");
                }
                if (f_groups == null) {
                    throw new JsonParseException(p, "Required field \"groups\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamMemberProfile value = new TeamMemberProfile(f_teamMemberId, f_email, f_emailVerified, f_status, f_name, f_membershipType, f_groups, f_externalId, f_accountId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends MemberProfile.Builder {
        protected final List<String> groups;

        protected Builder(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType, List<String> groups) {
            super(teamMemberId, email, emailVerified, status, name, membershipType);
            if (groups == null) {
                throw new IllegalArgumentException("Required value for 'groups' is null");
            }
            for (String x : groups) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'groups' is null");
            }
            this.groups = groups;
        }

        @Override
        public Builder withExternalId(String externalId) {
            super.withExternalId(externalId);
            return this;
        }

        @Override
        public Builder withAccountId(String accountId) {
            super.withAccountId(accountId);
            return this;
        }

        @Override
        public TeamMemberProfile build() {
            return new TeamMemberProfile(this.teamMemberId, this.email, this.emailVerified, this.status, this.name, this.membershipType, this.groups, this.externalId, this.accountId);
        }
    }
}

