/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum SharedFolderAccessError {
    INVALID_ID,
    NOT_A_MEMBER,
    EMAIL_UNVERIFIED,
    UNMOUNTED,
    OTHER;


    static class Serializer
    extends UnionSerializer<SharedFolderAccessError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedFolderAccessError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INVALID_ID: {
                    g.writeString("invalid_id");
                    break;
                }
                case NOT_A_MEMBER: {
                    g.writeString("not_a_member");
                    break;
                }
                case EMAIL_UNVERIFIED: {
                    g.writeString("email_unverified");
                    break;
                }
                case UNMOUNTED: {
                    g.writeString("unmounted");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SharedFolderAccessError deserialize(JsonParser p) throws IOException, JsonParseException {
            SharedFolderAccessError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("invalid_id".equals(tag)) {
                value = INVALID_ID;
            } else if ("not_a_member".equals(tag)) {
                value = NOT_A_MEMBER;
            } else if ("email_unverified".equals(tag)) {
                value = EMAIL_UNVERIFIED;
            } else if ("unmounted".equals(tag)) {
                value = UNMOUNTED;
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

