/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.HashMap;
import java.util.Map;

public abstract class BoxJSONObject {
    private JsonObject pendingChanges;
    private final Map<String, BoxJSONObject> children = new HashMap<String, BoxJSONObject>();

    public BoxJSONObject() {
    }

    public BoxJSONObject(String json) {
        this(JsonObject.readFrom((String)json));
    }

    BoxJSONObject(JsonObject jsonObject) {
        this();
        this.update(jsonObject);
    }

    public void clearPendingChanges() {
        this.pendingChanges = null;
    }

    public String getPendingChanges() {
        JsonObject jsonObject = this.getPendingJSONObject();
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.toString();
    }

    void parseJSONMember(JsonObject.Member member) {
    }

    void addPendingChange(String key, boolean value) {
        if (this.pendingChanges == null) {
            this.pendingChanges = new JsonObject();
        }
        this.pendingChanges.set(key, value);
    }

    void addPendingChange(String key, String value) {
        this.addPendingChange(key, JsonValue.valueOf((String)value));
    }

    void addPendingChange(String key, long value) {
        this.addPendingChange(key, JsonValue.valueOf((long)value));
    }

    void addChildObject(String fieldName, BoxJSONObject child) {
        if (child == null) {
            this.addPendingChange(fieldName, JsonValue.NULL);
        } else {
            this.children.put(fieldName, child);
        }
    }

    void removeChildObject(String fieldName) {
        this.children.remove(fieldName);
    }

    private void addPendingChange(String key, JsonValue value) {
        if (this.pendingChanges == null) {
            this.pendingChanges = new JsonObject();
        }
        this.pendingChanges.set(key, value);
    }

    void removePendingChange(String key) {
        if (this.pendingChanges != null) {
            this.pendingChanges.remove(key);
        }
    }

    void update(JsonObject jsonObject) {
        for (JsonObject.Member member : jsonObject) {
            if (member.getValue().isNull()) continue;
            this.parseJSONMember(member);
        }
        this.clearPendingChanges();
    }

    private JsonObject getPendingJSONObject() {
        for (Map.Entry<String, BoxJSONObject> entry : this.children.entrySet()) {
            BoxJSONObject child = entry.getValue();
            JsonObject jsonObject = child.getPendingJSONObject();
            if (jsonObject == null) continue;
            if (this.pendingChanges == null) {
                this.pendingChanges = new JsonObject();
            }
            this.pendingChanges.set(entry.getKey(), (JsonValue)jsonObject);
        }
        return this.pendingChanges;
    }
}

