/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.SharedFileMetadata;
import com.dropbox.core.v2.sharing.SharingFileAccessError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class GetFileMetadataIndividualResult {
    public static final GetFileMetadataIndividualResult OTHER = new GetFileMetadataIndividualResult(Tag.OTHER, null, null);
    private final Tag _tag;
    private final SharedFileMetadata metadataValue;
    private final SharingFileAccessError accessErrorValue;

    private GetFileMetadataIndividualResult(Tag _tag, SharedFileMetadata metadataValue, SharingFileAccessError accessErrorValue) {
        this._tag = _tag;
        this.metadataValue = metadataValue;
        this.accessErrorValue = accessErrorValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isMetadata() {
        return this._tag == Tag.METADATA;
    }

    public static GetFileMetadataIndividualResult metadata(SharedFileMetadata value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GetFileMetadataIndividualResult(Tag.METADATA, value, null);
    }

    public SharedFileMetadata getMetadataValue() {
        if (this._tag != Tag.METADATA) {
            throw new IllegalStateException("Invalid tag: required Tag.METADATA, but was Tag." + this._tag.name());
        }
        return this.metadataValue;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static GetFileMetadataIndividualResult accessError(SharingFileAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GetFileMetadataIndividualResult(Tag.ACCESS_ERROR, null, value);
    }

    public SharingFileAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.metadataValue, this.accessErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GetFileMetadataIndividualResult) {
            GetFileMetadataIndividualResult other = (GetFileMetadataIndividualResult)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case METADATA: {
                    return this.metadataValue == other.metadataValue || this.metadataValue.equals(other.metadataValue);
                }
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<GetFileMetadataIndividualResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetFileMetadataIndividualResult value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case METADATA: {
                    g.writeStartObject();
                    this.writeTag("metadata", g);
                    SharedFileMetadata.Serializer.INSTANCE.serialize(value.metadataValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    this.writeTag("access_error", g);
                    g.writeFieldName("access_error");
                    SharingFileAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public GetFileMetadataIndividualResult deserialize(JsonParser p) throws IOException, JsonParseException {
            GetFileMetadataIndividualResult value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("metadata".equals(tag)) {
                SharedFileMetadata fieldValue = null;
                fieldValue = SharedFileMetadata.Serializer.INSTANCE.deserialize(p, true);
                value = GetFileMetadataIndividualResult.metadata(fieldValue);
            } else if ("access_error".equals(tag)) {
                SharingFileAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = SharingFileAccessError.Serializer.INSTANCE.deserialize(p);
                value = GetFileMetadataIndividualResult.accessError(fieldValue);
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        METADATA,
        ACCESS_ERROR,
        OTHER;

    }
}

