/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import org.nuxeo.onedrive.client.OneDriveJsonObject;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveIdentity
extends OneDriveJsonObject {
    private String id;
    private String displayName;

    public OneDriveIdentity(JsonObject json) {
        super(json);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    protected void parseMember(JsonObject.Member member) {
        super.parseMember(member);
        try {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("id".equals(memberName)) {
                this.id = value.asString();
            } else if ("displayName".equals(memberName)) {
                this.displayName = value.asString();
            }
        }
        catch (ParseException e) {
            throw new OneDriveRuntimeException("Parse failed, maybe a bug in client.", e);
        }
    }
}

