/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.DbxSessionStore;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.util.StringUtil;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DbxWebAuth {
    private static final SecureRandom RAND = new SecureRandom();
    private static final int CSRF_BYTES_SIZE = 16;
    private static final int CSRF_STRING_SIZE = StringUtil.urlSafeBase64Encode(new byte[16]).length();
    public static final String ROLE_WORK = "work";
    public static final String ROLE_PERSONAL = "personal";
    private final DbxRequestConfig requestConfig;
    private final DbxAppInfo appInfo;
    private final Request deprecatedRequest;

    @Deprecated
    public DbxWebAuth(DbxRequestConfig requestConfig, DbxAppInfo appInfo, String redirectUri, DbxSessionStore sessionStore) {
        if (requestConfig == null) {
            throw new NullPointerException("requestConfig");
        }
        if (appInfo == null) {
            throw new NullPointerException("appInfo");
        }
        this.requestConfig = requestConfig;
        this.appInfo = appInfo;
        this.deprecatedRequest = DbxWebAuth.newRequestBuilder().withRedirectUri(redirectUri, sessionStore).build();
    }

    public DbxWebAuth(DbxRequestConfig requestConfig, DbxAppInfo appInfo) {
        if (requestConfig == null) {
            throw new NullPointerException("requestConfig");
        }
        if (appInfo == null) {
            throw new NullPointerException("appInfo");
        }
        this.requestConfig = requestConfig;
        this.appInfo = appInfo;
        this.deprecatedRequest = null;
    }

    @Deprecated
    public String start(String urlState) {
        if (this.deprecatedRequest == null) {
            throw new IllegalStateException("Must use DbxWebAuth.authorize instead.");
        }
        return this.authorizeImpl(this.deprecatedRequest.copy().withState(urlState).build());
    }

    public String authorize(Request request) {
        if (this.deprecatedRequest != null) {
            throw new IllegalStateException("Must create this instance using DbxWebAuth(DbxRequestConfig,DbxAppInfo) to call this method.");
        }
        return this.authorizeImpl(request);
    }

    private String authorizeImpl(Request request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.appInfo.getKey());
        params.put("response_type", "code");
        if (request.redirectUri != null) {
            params.put("redirect_uri", request.redirectUri);
            params.put("state", DbxWebAuth.appendCsrfToken(request));
        }
        if (request.requireRole != null) {
            params.put("require_role", request.requireRole);
        }
        if (request.forceReapprove != null) {
            params.put("force_reapprove", Boolean.toString(request.forceReapprove).toLowerCase());
        }
        if (request.disableSignup != null) {
            params.put("disable_signup", Boolean.toString(request.disableSignup).toLowerCase());
        }
        return DbxRequestUtil.buildUrlWithParams(this.requestConfig.getUserLocale(), this.appInfo.getHost().getWeb(), "oauth2/authorize", DbxRequestUtil.toParamsArray(params));
    }

    public DbxAuthFinish finishFromCode(String code) throws DbxException {
        return this.finish(code);
    }

    public DbxAuthFinish finishFromRedirect(String redirectUri, DbxSessionStore sessionStore, Map<String, String[]> params) throws DbxException, BadRequestException, BadStateException, CsrfException, NotApprovedException, ProviderException {
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri");
        }
        if (sessionStore == null) {
            throw new NullPointerException("sessionStore");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        String state = DbxWebAuth.getParam(params, "state");
        if (state == null) {
            throw new BadRequestException("Missing required parameter: \"state\".");
        }
        String error = DbxWebAuth.getParam(params, "error");
        String code = DbxWebAuth.getParam(params, "code");
        String errorDescription = DbxWebAuth.getParam(params, "error_description");
        if (code == null && error == null) {
            throw new BadRequestException("Missing both \"code\" and \"error\".");
        }
        if (code != null && error != null) {
            throw new BadRequestException("Both \"code\" and \"error\" are set.");
        }
        if (code != null && errorDescription != null) {
            throw new BadRequestException("Both \"code\" and \"error_description\" are set.");
        }
        state = DbxWebAuth.verifyAndStripCsrfToken(state, sessionStore);
        if (error != null) {
            if (error.equals("access_denied")) {
                String exceptionMessage = errorDescription == null ? "No additional description from Dropbox" : "Additional description from Dropbox: " + errorDescription;
                throw new NotApprovedException(exceptionMessage);
            }
            String exceptionMessage = errorDescription == null ? error : String.format("%s: %s", error, errorDescription);
            throw new ProviderException(exceptionMessage);
        }
        return this.finish(code, redirectUri, state);
    }

    private DbxAuthFinish finish(String code) throws DbxException {
        return this.finish(code, null, null);
    }

    private DbxAuthFinish finish(String code, String redirectUri, final String state) throws DbxException {
        if (code == null) {
            throw new NullPointerException("code");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        params.put("locale", this.requestConfig.getUserLocale());
        if (redirectUri != null) {
            params.put("redirect_uri", redirectUri);
        }
        ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        DbxRequestUtil.addBasicAuthHeader(headers, this.appInfo.getKey(), this.appInfo.getSecret());
        return DbxRequestUtil.doPostNoAuth(this.requestConfig, "OfficialDropboxJavaSDKv2", this.appInfo.getHost().getApi(), "oauth2/token", DbxRequestUtil.toParamsArray(params), headers, new DbxRequestUtil.ResponseHandler<DbxAuthFinish>(){

            @Override
            public DbxAuthFinish handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxAuthFinish.Reader, response).withUrlState(state);
            }
        });
    }

    @Deprecated
    public DbxAuthFinish finish(Map<String, String[]> queryParams) throws DbxException, BadRequestException, BadStateException, CsrfException, NotApprovedException, ProviderException {
        if (this.deprecatedRequest == null) {
            throw new IllegalStateException("Must use DbxWebAuth.finishFromRedirect(..) instead.");
        }
        return this.finishFromRedirect(this.deprecatedRequest.redirectUri, this.deprecatedRequest.sessionStore, queryParams);
    }

    private static String appendCsrfToken(Request request) {
        byte[] csrf = new byte[16];
        RAND.nextBytes(csrf);
        String prefix = StringUtil.urlSafeBase64Encode(csrf);
        if (prefix.length() != CSRF_STRING_SIZE) {
            throw new AssertionError((Object)("unexpected CSRF token length: " + prefix.length()));
        }
        if (request.sessionStore != null) {
            request.sessionStore.set(prefix);
        }
        if (request.state == null) {
            return prefix;
        }
        String combined = prefix + request.state;
        if (combined.length() > 500) {
            throw new AssertionError((Object)("unexpected combined state length: " + combined.length()));
        }
        return combined;
    }

    private static String verifyAndStripCsrfToken(String state, DbxSessionStore sessionStore) throws CsrfException, BadStateException {
        String expected = sessionStore.get();
        if (expected == null) {
            throw new BadStateException("No CSRF Token loaded from session store.");
        }
        if (expected.length() < CSRF_STRING_SIZE) {
            throw new BadStateException("Token retrieved from session store is too small: " + expected);
        }
        if (state.length() < CSRF_STRING_SIZE) {
            throw new CsrfException("Token too small: " + state);
        }
        String actual = state.substring(0, CSRF_STRING_SIZE);
        if (!StringUtil.secureStringEquals(expected, actual)) {
            throw new CsrfException("expecting " + StringUtil.jq(expected) + ", got " + StringUtil.jq(actual));
        }
        String stripped = state.substring(CSRF_STRING_SIZE, state.length());
        sessionStore.clear();
        return stripped.isEmpty() ? null : stripped;
    }

    private static String getParam(Map<String, String[]> params, String name) throws BadRequestException {
        String[] v = params.get(name);
        if (v == null) {
            return null;
        }
        if (v.length == 0) {
            throw new IllegalArgumentException("Parameter \"" + name + "\" missing value.");
        }
        if (v.length == 1) {
            return v[0];
        }
        throw new BadRequestException("multiple occurrences of \"" + name + "\" parameter");
    }

    public static Request.Builder newRequestBuilder() {
        return Request.newBuilder();
    }

    public static final class Request {
        private static final Charset UTF8 = Charset.forName("UTF-8");
        private static final int MAX_STATE_SIZE = 500;
        private final String redirectUri;
        private final String state;
        private final String requireRole;
        private final Boolean forceReapprove;
        private final Boolean disableSignup;
        private final DbxSessionStore sessionStore;

        private Request(String redirectUri, String state, String requireRole, Boolean forceReapprove, Boolean disableSignup, DbxSessionStore sessionStore) {
            this.redirectUri = redirectUri;
            this.state = state;
            this.requireRole = requireRole;
            this.forceReapprove = forceReapprove;
            this.disableSignup = disableSignup;
            this.sessionStore = sessionStore;
        }

        public Builder copy() {
            return new Builder(this.redirectUri, this.state, this.requireRole, this.forceReapprove, this.disableSignup, this.sessionStore);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private String redirectUri;
            private String state;
            private String requireRole;
            private Boolean forceReapprove;
            private Boolean disableSignup;
            private DbxSessionStore sessionStore;

            private Builder() {
                this(null, null, null, null, null, null);
            }

            private Builder(String redirectUri, String state, String requireRole, Boolean forceReapprove, Boolean disableSignup, DbxSessionStore sessionStore) {
                this.redirectUri = redirectUri;
                this.state = state;
                this.requireRole = requireRole;
                this.forceReapprove = forceReapprove;
                this.disableSignup = disableSignup;
                this.sessionStore = sessionStore;
            }

            public Builder withNoRedirect() {
                this.redirectUri = null;
                this.sessionStore = null;
                return this;
            }

            public Builder withRedirectUri(String redirectUri, DbxSessionStore sessionStore) {
                if (redirectUri == null) {
                    throw new NullPointerException("redirectUri");
                }
                if (sessionStore == null) {
                    throw new NullPointerException("sessionStore");
                }
                this.redirectUri = redirectUri;
                this.sessionStore = sessionStore;
                return this;
            }

            public Builder withState(String state) {
                if (state != null && state.getBytes(UTF8).length + CSRF_STRING_SIZE > 500) {
                    throw new IllegalArgumentException("UTF-8 encoded state cannot be greater than " + (500 - CSRF_STRING_SIZE) + " bytes.");
                }
                this.state = state;
                return this;
            }

            public Builder withRequireRole(String requireRole) {
                this.requireRole = requireRole;
                return this;
            }

            public Builder withForceReapprove(Boolean forceReapprove) {
                this.forceReapprove = forceReapprove;
                return this;
            }

            public Builder withDisableSignup(Boolean disableSignup) {
                this.disableSignup = disableSignup;
                return this;
            }

            public Request build() {
                if (this.redirectUri == null && this.state != null) {
                    throw new IllegalStateException("Cannot specify a state without a redirect URI.");
                }
                return new Request(this.redirectUri, this.state, this.requireRole, this.forceReapprove, this.disableSignup, this.sessionStore);
            }
        }
    }

    public static final class ProviderException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public ProviderException(String message) {
            super(message);
        }
    }

    public static final class NotApprovedException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public NotApprovedException(String message) {
            super(message);
        }
    }

    public static final class CsrfException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public CsrfException(String message) {
            super(message);
        }
    }

    public static final class BadStateException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public BadStateException(String message) {
            super(message);
        }
    }

    public static final class BadRequestException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public BadRequestException(String message) {
            super(message);
        }
    }

    public static abstract class Exception
    extends java.lang.Exception {
        private static final long serialVersionUID = 0L;

        public Exception(String message) {
            super(message);
        }
    }
}

