/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.users.Account;
import com.dropbox.core.v2.users.Name;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class BasicAccount
extends Account {
    protected final boolean isTeammate;
    protected final String teamMemberId;

    public BasicAccount(String accountId, Name name, String email, boolean emailVerified, boolean disabled, boolean isTeammate, String profilePhotoUrl, String teamMemberId) {
        super(accountId, name, email, emailVerified, disabled, profilePhotoUrl);
        this.isTeammate = isTeammate;
        this.teamMemberId = teamMemberId;
    }

    public BasicAccount(String accountId, Name name, String email, boolean emailVerified, boolean disabled, boolean isTeammate) {
        this(accountId, name, email, emailVerified, disabled, isTeammate, null, null);
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean getEmailVerified() {
        return this.emailVerified;
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    public boolean getIsTeammate() {
        return this.isTeammate;
    }

    @Override
    public String getProfilePhotoUrl() {
        return this.profilePhotoUrl;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public static Builder newBuilder(String accountId, Name name, String email, boolean emailVerified, boolean disabled, boolean isTeammate) {
        return new Builder(accountId, name, email, emailVerified, disabled, isTeammate);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.isTeammate, this.teamMemberId});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            BasicAccount other = (BasicAccount)obj;
            return !(this.accountId != other.accountId && !this.accountId.equals(other.accountId) || this.name != other.name && !this.name.equals(other.name) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.disabled != other.disabled || this.isTeammate != other.isTeammate || this.profilePhotoUrl != other.profilePhotoUrl && (this.profilePhotoUrl == null || !this.profilePhotoUrl.equals(other.profilePhotoUrl)) || this.teamMemberId != other.teamMemberId && (this.teamMemberId == null || !this.teamMemberId.equals(other.teamMemberId)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<BasicAccount> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(BasicAccount value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("account_id");
            StoneSerializers.string().serialize(value.accountId, g);
            g.writeFieldName("name");
            Name.Serializer.INSTANCE.serialize(value.name, g);
            g.writeFieldName("email");
            StoneSerializers.string().serialize(value.email, g);
            g.writeFieldName("email_verified");
            StoneSerializers.boolean_().serialize((Boolean)value.emailVerified, g);
            g.writeFieldName("disabled");
            StoneSerializers.boolean_().serialize((Boolean)value.disabled, g);
            g.writeFieldName("is_teammate");
            StoneSerializers.boolean_().serialize((Boolean)value.isTeammate, g);
            if (value.profilePhotoUrl != null) {
                g.writeFieldName("profile_photo_url");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.profilePhotoUrl, g);
            }
            if (value.teamMemberId != null) {
                g.writeFieldName("team_member_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.teamMemberId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public BasicAccount deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_teamMemberId;
            String f_profilePhotoUrl;
            Boolean f_isTeammate;
            Boolean f_disabled;
            Boolean f_emailVerified;
            String f_email;
            Name f_name;
            String f_accountId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accountId = null;
                f_name = null;
                f_email = null;
                f_emailVerified = null;
                f_disabled = null;
                f_isTeammate = null;
                f_profilePhotoUrl = null;
                f_teamMemberId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = (Name)Name.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email_verified".equals(field)) {
                        f_emailVerified = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("disabled".equals(field)) {
                        f_disabled = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("is_teammate".equals(field)) {
                        f_isTeammate = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("profile_photo_url".equals(field)) {
                        f_profilePhotoUrl = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accountId == null) {
                    throw new JsonParseException(p, "Required field \"account_id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_email == null) {
                    throw new JsonParseException(p, "Required field \"email\" missing.");
                }
                if (f_emailVerified == null) {
                    throw new JsonParseException(p, "Required field \"email_verified\" missing.");
                }
                if (f_disabled == null) {
                    throw new JsonParseException(p, "Required field \"disabled\" missing.");
                }
                if (f_isTeammate == null) {
                    throw new JsonParseException(p, "Required field \"is_teammate\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            BasicAccount value = new BasicAccount(f_accountId, f_name, f_email, f_emailVerified, f_disabled, f_isTeammate, f_profilePhotoUrl, f_teamMemberId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String accountId;
        protected final Name name;
        protected final String email;
        protected final boolean emailVerified;
        protected final boolean disabled;
        protected final boolean isTeammate;
        protected String profilePhotoUrl;
        protected String teamMemberId;

        protected Builder(String accountId, Name name, String email, boolean emailVerified, boolean disabled, boolean isTeammate) {
            if (accountId == null) {
                throw new IllegalArgumentException("Required value for 'accountId' is null");
            }
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
            this.accountId = accountId;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (email == null) {
                throw new IllegalArgumentException("Required value for 'email' is null");
            }
            this.email = email;
            this.emailVerified = emailVerified;
            this.disabled = disabled;
            this.isTeammate = isTeammate;
            this.profilePhotoUrl = null;
            this.teamMemberId = null;
        }

        public Builder withProfilePhotoUrl(String profilePhotoUrl) {
            this.profilePhotoUrl = profilePhotoUrl;
            return this;
        }

        public Builder withTeamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public BasicAccount build() {
            return new BasicAccount(this.accountId, this.name, this.email, this.emailVerified, this.disabled, this.isTeammate, this.profilePhotoUrl, this.teamMemberId);
        }
    }
}

