/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive;

import com.google.api.services.drive.model.File;
import java.util.Objects;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;

public class GoogleDriveLiveConnectFile
extends AbstractLiveConnectFile {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private final long fileSize;
    private final String digest;
    private final String mimeType;

    public GoogleDriveLiveConnectFile(LiveConnectFileInfo fileInfo, File file) {
        super(fileInfo);
        this.filename = Objects.requireNonNull(file.getTitle());
        this.fileSize = file.getFileSize() != null ? file.getFileSize() : -1L;
        this.digest = Objects.requireNonNull(GoogleDriveLiveConnectFile.getDigest(file));
        this.mimeType = Objects.requireNonNull(file.getMimeType());
    }

    public String getFilename() {
        return this.filename;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static String getDigest(File file) {
        return file.getMd5Checksum() == null ? file.getEtag() : file.getMd5Checksum();
    }
}

