/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.SearchMode;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class SearchArg {
    protected final String path;
    protected final String query;
    protected final long start;
    protected final long maxResults;
    protected final SearchMode mode;

    public SearchArg(String path, String query, long start, long maxResults, SearchMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*)?|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (query == null) {
            throw new IllegalArgumentException("Required value for 'query' is null");
        }
        this.query = query;
        this.start = start;
        if (maxResults < 1L) {
            throw new IllegalArgumentException("Number 'maxResults' is smaller than 1L");
        }
        if (maxResults > 1000L) {
            throw new IllegalArgumentException("Number 'maxResults' is larger than 1000L");
        }
        this.maxResults = maxResults;
        if (mode == null) {
            throw new IllegalArgumentException("Required value for 'mode' is null");
        }
        this.mode = mode;
    }

    public SearchArg(String path, String query) {
        this(path, query, 0L, 100L, SearchMode.FILENAME);
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public long getStart() {
        return this.start;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public SearchMode getMode() {
        return this.mode;
    }

    public static Builder newBuilder(String path, String query) {
        return new Builder(path, query);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.query, this.start, this.maxResults, this.mode});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SearchArg other = (SearchArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.query != other.query && !this.query.equals(other.query) || this.start != other.start || this.maxResults != other.maxResults || this.mode != other.mode && !this.mode.equals((Object)other.mode));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SearchArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("query");
            StoneSerializers.string().serialize(value.query, g);
            g.writeFieldName("start");
            StoneSerializers.uInt64().serialize((Long)value.start, g);
            g.writeFieldName("max_results");
            StoneSerializers.uInt64().serialize((Long)value.maxResults, g);
            g.writeFieldName("mode");
            SearchMode.Serializer.INSTANCE.serialize(value.mode, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SearchArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            SearchMode f_mode;
            Long f_maxResults;
            Long f_start;
            String f_query;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_query = null;
                f_start = 0L;
                f_maxResults = 100L;
                f_mode = SearchMode.FILENAME;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("query".equals(field)) {
                        f_query = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("start".equals(field)) {
                        f_start = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("max_results".equals(field)) {
                        f_maxResults = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("mode".equals(field)) {
                        f_mode = SearchMode.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
                if (f_query == null) {
                    throw new JsonParseException(p, "Required field \"query\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SearchArg value = new SearchArg(f_path, f_query, f_start, f_maxResults, f_mode);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String path;
        protected final String query;
        protected long start;
        protected long maxResults;
        protected SearchMode mode;

        protected Builder(String path, String query) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("(/(.|[\\r\\n])*)?|(ns:[0-9]+(/.*)?)", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            if (query == null) {
                throw new IllegalArgumentException("Required value for 'query' is null");
            }
            this.query = query;
            this.start = 0L;
            this.maxResults = 100L;
            this.mode = SearchMode.FILENAME;
        }

        public Builder withStart(Long start) {
            this.start = start != null ? start : 0L;
            return this;
        }

        public Builder withMaxResults(Long maxResults) {
            if (maxResults < 1L) {
                throw new IllegalArgumentException("Number 'maxResults' is smaller than 1L");
            }
            if (maxResults > 1000L) {
                throw new IllegalArgumentException("Number 'maxResults' is larger than 1000L");
            }
            this.maxResults = maxResults != null ? maxResults : 100L;
            return this;
        }

        public Builder withMode(SearchMode mode) {
            this.mode = mode != null ? mode : SearchMode.FILENAME;
            return this;
        }

        public SearchArg build() {
            return new SearchArg(this.path, this.query, this.start, this.maxResults, this.mode);
        }
    }
}

