/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.DriveRequest;
import com.google.api.services.drive.model.App;
import com.google.api.services.drive.model.Revision;
import com.google.api.services.drive.model.RevisionList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.CredentialFactory;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.core.OAuth2CredentialFactory;
import org.nuxeo.ecm.liveconnect.google.drive.GoogleDriveLiveConnectFile;
import org.nuxeo.ecm.liveconnect.google.drive.GoogleOAuth2ServiceProvider;
import org.nuxeo.ecm.liveconnect.google.drive.credential.ServiceAccountCredentialFactory;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class GoogleDriveBlobProvider
extends AbstractLiveConnectBlobProvider<GoogleOAuth2ServiceProvider> {
    public static final int PREFERRED_ICON_SIZE = 16;
    public static final String SERVICE_ACCOUNT_ID_PROP = "serviceAccountId";
    public static final String SERVICE_ACCOUNT_P12_PATH_PROP = "serviceAccountP12Path";
    public static final String CLIENT_ID_PROP = "clientId";
    public static final String DEFAULT_EXPORT_MIMETYPE = "application/pdf";
    protected static final String BLOB_CONVERSIONS_FACET = "BlobConversions";
    protected static final String BLOB_CONVERSIONS_PROPERTY = "blobconversions:conversions";
    protected static final String BLOB_CONVERSION_KEY = "key";
    protected static final String BLOB_CONVERSION_BLOB = "blob";
    protected static final ObjectParser JSON_PARSER = new JsonObjectParser((JsonFactory)JacksonFactory.getDefaultInstance());
    private static final String GOOGLEDRIVE_DOCUMENT_TO_BE_UPDATED_PP = "googledrive_document_to_be_updated";
    private static final String APPLICATION_NAME = "Nuxeo/0";
    private static final String FILE_CACHE_NAME = "googleDrive";
    private String serviceAccountId;
    private File serviceAccountP12File;
    private String clientId;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.serviceAccountId = properties.get(SERVICE_ACCOUNT_ID_PROP);
        if (StringUtils.isBlank((String)this.serviceAccountId)) {
            return;
        }
        String p12 = properties.get(SERVICE_ACCOUNT_P12_PATH_PROP);
        if (StringUtils.isBlank((String)p12)) {
            throw new NuxeoException("Missing value for property: serviceAccountP12Path");
        }
        this.serviceAccountP12File = new File(p12);
        if (!this.serviceAccountP12File.exists()) {
            throw new NuxeoException("No such file: " + p12 + " for property: " + SERVICE_ACCOUNT_P12_PATH_PROP);
        }
        this.clientId = properties.get(CLIENT_ID_PROP);
        if (StringUtils.isBlank((String)this.clientId)) {
            throw new NuxeoException("Missing value for property: clientId");
        }
    }

    protected String getCacheName() {
        return FILE_CACHE_NAME;
    }

    public String getPageProviderNameForUpdate() {
        return GOOGLEDRIVE_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        String url = null;
        switch (usage) {
            case STREAM: {
                url = this.getStreamUrl(blob);
                break;
            }
            case DOWNLOAD: {
                url = this.getDownloadUrl(blob);
                break;
            }
            case VIEW: 
            case EDIT: {
                url = this.getAlternateUrl(blob);
                break;
            }
            case EMBED: {
                url = this.getEmbedUrl(blob);
            }
        }
        return url == null ? null : this.asURI(url);
    }

    public Map<String, URI> getAvailableConversions(ManagedBlob blob, BlobManager.UsageHint hint) throws IOException {
        Map<String, String> exportLinks = this.getExportLinks(blob);
        if (exportLinks == null) {
            return Collections.emptyMap();
        }
        HashMap<String, URI> conversions = new HashMap<String, URI>();
        for (String mimeType : exportLinks.keySet()) {
            conversions.put(mimeType, this.asURI(exportLinks.get(mimeType)));
        }
        return conversions;
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        String url = this.getThumbnailUrl(blob);
        return this.getStream(blob, this.asURI(url));
    }

    protected String getStreamUrl(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            Revision revision = this.getRevision(fileInfo);
            return revision != null ? revision.getDownloadUrl() : null;
        }
        com.google.api.services.drive.model.File file = this.getDriveFile(fileInfo);
        return file.getDownloadUrl();
    }

    protected String getDownloadUrl(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String url = null;
        if (fileInfo.getRevisionId().isPresent()) {
            Revision revision = this.getRevision(fileInfo);
            if (revision != null) {
                url = revision.getDownloadUrl();
                if (StringUtils.isBlank((String)url)) {
                    url = (String)revision.getExportLinks().get(DEFAULT_EXPORT_MIMETYPE);
                }
                if (url.endsWith("&gd=true")) {
                    url = url.substring(0, url.length() - "&gd=true".length());
                }
            }
        } else {
            com.google.api.services.drive.model.File file = this.getDriveFile(fileInfo);
            url = file.getWebContentLink();
            if (url == null) {
                url = file.getAlternateLink();
            }
        }
        return url;
    }

    protected String getAlternateUrl(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        com.google.api.services.drive.model.File file = this.getDriveFile(fileInfo);
        return file.getAlternateLink();
    }

    protected String getEmbedUrl(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        com.google.api.services.drive.model.File file = this.getDriveFile(fileInfo);
        String url = file.getEmbedLink();
        if (url == null) {
            url = file.getAlternateLink();
            url = this.asURI(url).resolve("./preview").toString();
        }
        return url;
    }

    protected String getThumbnailUrl(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        com.google.api.services.drive.model.File file = this.getDriveFile(fileInfo);
        return file.getThumbnailLink();
    }

    protected Map<String, String> getExportLinks(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            Revision revision = this.getRevision(fileInfo);
            return revision != null && Boolean.TRUE.equals(revision.getPinned()) ? revision.getExportLinks() : Collections.emptyMap();
        }
        com.google.api.services.drive.model.File file = this.getDriveFile(fileInfo);
        return file.getExportLinks();
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        URI uri = this.getURI(blob, BlobManager.UsageHint.STREAM, null);
        return uri == null ? null : this.getStream(blob, uri);
    }

    public InputStream getConvertedStream(ManagedBlob blob, String mimeType, DocumentModel doc) throws IOException {
        Blob conversion = this.retrieveBlobConversion(blob, mimeType, doc);
        if (conversion != null) {
            return conversion.getStream();
        }
        Map<String, URI> conversions = this.getAvailableConversions(blob, BlobManager.UsageHint.STREAM);
        URI uri = conversions.get(mimeType);
        if (uri == null) {
            return null;
        }
        return this.getStream(blob, uri);
    }

    protected InputStream getStream(ManagedBlob blob, URI uri) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        return this.doGet(fileInfo, uri);
    }

    public List<AppLink> getAppLinks(String username, ManagedBlob blob) throws IOException {
        ArrayList<AppLink> appLinks = new ArrayList<AppLink>();
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            return appLinks;
        }
        String user = this.getServiceUser(username);
        com.google.api.services.drive.model.File file = this.getPartialFile(user, fileInfo.getFileId(), "openWithLinks", "defaultOpenWithLink");
        if (file.isEmpty()) {
            return appLinks;
        }
        String defaultLink = file.getDefaultOpenWithLink();
        for (Map.Entry entry : file.getOpenWithLinks().entrySet()) {
            App app = this.getApp(user, (String)entry.getKey());
            AppLink appLink = new AppLink();
            appLink.setAppName(app.getName());
            appLink.setLink((String)entry.getValue());
            List icons = app.getIcons();
            if (icons != null) {
                for (App.Icons icon : icons) {
                    if (!"application".equals(icon.getCategory())) continue;
                    appLink.setIcon(icon.getIconUrl());
                    if (icon.getSize() != 16) continue;
                    break;
                }
            }
            if (defaultLink != null && defaultLink.equals(entry.getValue())) {
                appLinks.add(0, appLink);
                continue;
            }
            appLinks.add(appLink);
        }
        return appLinks;
    }

    protected String getServiceUser(String username) {
        CredentialFactory credentialFactory = this.getCredentialFactory();
        if (credentialFactory instanceof OAuth2CredentialFactory) {
            return ((GoogleOAuth2ServiceProvider)this.getOAuth2Provider()).getServiceUser(username);
        }
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        DocumentModel user = userManager.getUserModel(username);
        if (user == null) {
            return null;
        }
        return (String)((Object)user.getPropertyValue(userManager.getUserEmailField()));
    }

    protected App getApp(String user, String appId) throws IOException {
        String cacheKey = "app_" + appId;
        return this.executeAndCache(cacheKey, (DriveRequest)this.getService(user).apps().get(appId), (Class)App.class);
    }

    public ManagedBlob freezeVersion(ManagedBlob blob, Document doc) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            return null;
        }
        String user = fileInfo.getUser();
        String fileId = fileInfo.getFileId();
        this.putFileInCache(this.retrieveFile(fileInfo));
        com.google.api.services.drive.model.File driveFile = this.getDriveFile(fileInfo);
        String revisionId = driveFile.getHeadRevisionId();
        if (revisionId != null) {
            fileInfo = new LiveConnectFileInfo(user, fileId, revisionId);
            Revision revision = this.getRevision(fileInfo);
            if (!Boolean.TRUE.equals(revision.getPinned())) {
                Revision pinRevision = new Revision();
                pinRevision.setPinned(Boolean.TRUE);
                this.getService(user).revisions().patch(fileId, revisionId, pinRevision).executeUnparsed().ignore();
            }
        } else {
            List list = this.getRevisionList(fileInfo).getItems();
            if (list.isEmpty()) {
                return null;
            }
            Revision revision = (Revision)list.get(list.size() - 1);
            URI uri = this.asURI((String)revision.getExportLinks().get(DEFAULT_EXPORT_MIMETYPE));
            InputStream is = this.doGet(fileInfo, uri);
            Blob conversion = Blobs.createBlob((InputStream)is);
            conversion.setFilename(blob.getFilename());
            conversion.setMimeType(DEFAULT_EXPORT_MIMETYPE);
            fileInfo = new LiveConnectFileInfo(user, fileId, revision.getId());
            this.storeBlobConversion(doc, this.buildBlobKey(fileInfo), conversion);
        }
        return this.toBlob((LiveConnectFile)new GoogleDriveLiveConnectFile(fileInfo, driveFile));
    }

    protected void storeBlobConversion(Document doc, String blobKey, Blob blob) {
        if (!doc.hasFacet(BLOB_CONVERSIONS_FACET)) {
            doc.addFacet(BLOB_CONVERSIONS_FACET);
        }
        List conversions = (List)doc.getValue(BLOB_CONVERSIONS_PROPERTY);
        HashMap<String, String> conversion = new HashMap<String, String>();
        conversion.put(BLOB_CONVERSION_KEY, blobKey);
        conversion.put(BLOB_CONVERSION_BLOB, (String)blob);
        conversions.add(conversion);
        doc.setValue(BLOB_CONVERSIONS_PROPERTY, (Object)conversions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob retrieveBlobConversion(ManagedBlob blob, String mimeType, DocumentModel doc) {
        if (doc == null || !doc.hasFacet(BLOB_CONVERSIONS_FACET)) {
            return null;
        }
        boolean txWasActive = TransactionHelper.isTransactionActiveOrMarkedRollback();
        try {
            if (!txWasActive) {
                TransactionHelper.startTransaction();
            }
            ListProperty conversions = (ListProperty)doc.getProperty(BLOB_CONVERSIONS_PROPERTY);
            for (int i = 0; i < conversions.size(); ++i) {
                String conversionXPath;
                Blob conversion;
                if (!blob.getKey().equals(conversions.get(i).getValue(BLOB_CONVERSION_KEY)) || !(conversion = (Blob)doc.getPropertyValue(conversionXPath = String.format("%s/%d/%s", BLOB_CONVERSIONS_PROPERTY, i, BLOB_CONVERSION_BLOB))).getMimeType().equals(mimeType)) continue;
                Blob blob2 = conversion;
                return blob2;
            }
        }
        finally {
            if (!txWasActive) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
        return null;
    }

    protected boolean hasChanged(SimpleManagedBlob blob, LiveConnectFile file) {
        return !blob.getFilename().equals(file.getFilename().replace('/', '-')) && super.hasChanged(blob, file);
    }

    protected CredentialFactory getCredentialFactory() {
        GoogleOAuth2ServiceProvider provider = (GoogleOAuth2ServiceProvider)this.getOAuth2Provider();
        if (provider != null && provider.isEnabled()) {
            return new OAuth2CredentialFactory((OAuth2ServiceProvider)provider);
        }
        return new ServiceAccountCredentialFactory(this.serviceAccountId, this.serviceAccountP12File);
    }

    protected Drive getService(String user) throws IOException {
        Credential credential = this.getCredential(user);
        if (credential == null) {
            throw new IOException("No credentials found for user " + user);
        }
        HttpTransport httpTransport = credential.getTransport();
        JsonFactory jsonFactory = credential.getJsonFactory();
        return new Drive.Builder(httpTransport, jsonFactory, (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        this.invalidateInCache(fileInfo);
        return new GoogleDriveLiveConnectFile(fileInfo, this.getDriveFile(fileInfo));
    }

    protected com.google.api.services.drive.model.File getPartialFile(String user, String fileId, String ... fields) throws IOException {
        return (com.google.api.services.drive.model.File)this.getService(user).files().get(fileId).setFields(StringUtils.join((Object[])fields, (String)",")).execute();
    }

    protected com.google.api.services.drive.model.File getDriveFile(LiveConnectFileInfo fileInfo) throws IOException {
        String fileId = fileInfo.getFileId();
        String cacheKey = "file_" + fileId;
        Drive.Files.Get request = this.getService(fileInfo.getUser()).files().get(fileId);
        return this.executeAndCache(cacheKey, (DriveRequest)request, (Class)com.google.api.services.drive.model.File.class);
    }

    protected Revision getRevision(LiveConnectFileInfo fileInfo) throws IOException {
        if (!fileInfo.getRevisionId().isPresent()) {
            throw new NullPointerException("null revisionId for " + fileInfo.getFileId());
        }
        String fileId = fileInfo.getFileId();
        String revisionId = (String)fileInfo.getRevisionId().get();
        String cacheKey = "rev_" + fileId + "_" + revisionId;
        Drive.Revisions.Get request = this.getService(fileInfo.getUser()).revisions().get(fileId, revisionId);
        try {
            return this.executeAndCache(cacheKey, (DriveRequest)request, (Class)Revision.class);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    protected <T> T executeAndCache(String cacheKey, DriveRequest<T> request, Class<T> aClass) throws IOException {
        String resource = this.getDriveFromCache(cacheKey);
        if (resource == null) {
            HttpResponse response = request.executeUnparsed();
            if (!response.isSuccessStatusCode()) {
                return null;
            }
            resource = response.parseAsString();
            if (cacheKey != null) {
                this.putDriveInCache(cacheKey, resource);
            }
        }
        return (T)JSON_PARSER.parseAndClose((Reader)new StringReader(resource), aClass);
    }

    protected RevisionList getRevisionList(LiveConnectFileInfo fileInfo) throws IOException {
        return (RevisionList)this.getService(fileInfo.getUser()).revisions().list(fileInfo.getFileId()).execute();
    }

    protected InputStream doGet(LiveConnectFileInfo fileInfo, URI url) throws IOException {
        HttpResponse response = this.getService(fileInfo.getUser()).getRequestFactory().buildGetRequest(new GenericUrl(url)).execute();
        return response.getContent();
    }

    public String getClientId() {
        GoogleOAuth2ServiceProvider provider = (GoogleOAuth2ServiceProvider)this.getOAuth2Provider();
        return provider != null && provider.isEnabled() ? provider.getClientId() : this.clientId;
    }

    private String getDriveFromCache(String key) {
        return (String)((Object)this.getFromCache(key));
    }

    private void putDriveInCache(String key, String resource) {
        this.putInCache(key, (Serializable)((Object)resource));
    }
}

