/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.liveconnect.box.BoxBlobProvider;
import org.nuxeo.ecm.liveconnect.box.BoxOAuth2ServiceProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploader;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

public class BoxBlobUploader
implements JSFBlobUploader {
    public static final String UPLOAD_BOX_FACET_NAME = "uploadBox";
    protected final String id;

    public BoxBlobUploader(String id) {
        this.id = id;
        try {
            this.getBoxBlobProvider();
        }
        catch (NuxeoException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getChoice() {
        return UPLOAD_BOX_FACET_NAME;
    }

    public void hookSubComponent(UIInput parent) {
        Application app = FacesContext.getCurrentInstance().getApplication();
        ComponentUtils.initiateSubComponent((UIComponent)parent, (String)UPLOAD_BOX_FACET_NAME, (UIComponent)app.createComponent("javax.faces.HtmlInputText"));
    }

    public void encodeBeginUpload(UIInput parent, FacesContext context, String onClick) throws IOException {
        UIComponent facet = parent.getFacet(UPLOAD_BOX_FACET_NAME);
        if (!(facet instanceof HtmlInputText)) {
            return;
        }
        HtmlInputText inputText = (HtmlInputText)facet;
        ResponseWriter writer = context.getResponseWriter();
        BoxOAuth2ServiceProvider provider = (BoxOAuth2ServiceProvider)this.getBoxBlobProvider().getOAuth2Provider();
        String inputId = facet.getClientId(context);
        String prefix = parent.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context);
        String pickId = prefix + "BoxPickMsg";
        String infoId = prefix + "BoxInfo";
        String authorizationUrl = this.hasServiceAccount(provider) ? "" : this.getOAuthAuthorizationUrl(provider);
        Locale locale = context.getViewRoot().getLocale();
        boolean isProviderAvailable = provider != null && provider.isProviderAvailable();
        writer.startElement("button", (UIComponent)parent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"button", null);
        if (isProviderAvailable) {
            String onButtonClick = onClick + ";" + String.format("new nuxeo.utils.BoxPicker('%s', '%s','%s', '%s')", this.getClientId(provider), inputId, infoId, authorizationUrl);
            writer.writeAttribute("onclick", (Object)onButtonClick, null);
        }
        writer.startElement("span", (UIComponent)parent);
        writer.writeAttribute("id", (Object)pickId, null);
        String message = I18NUtils.getMessageString((String)"messages", (String)"label.inputFile.boxUploadPicker", null, (Locale)locale);
        writer.write(message);
        writer.endElement("span");
        writer.endElement("button");
        if (isProviderAvailable) {
            writer.write("&#x0020;");
            writer.startElement("span", (UIComponent)parent);
            writer.writeAttribute("id", (Object)infoId, null);
            message = I18NUtils.getMessageString((String)"messages", (String)"error.inputFile.noFileSelected", null, (Locale)locale);
            writer.write(message);
            writer.endElement("span");
        } else {
            writer.startElement("span", (UIComponent)parent);
            writer.writeAttribute("class", (Object)"processMessage completeWarning", null);
            writer.writeAttribute("style", (Object)"margin: 0 0 .5em 0; font-size: 11px; padding: 0.4em 0.5em 0.5em 2.2em; background-position-y: 0.6em", null);
            message = I18NUtils.getMessageString((String)"messages", (String)"error.box.providerUnavailable", null, (Locale)locale);
            writer.write(message);
            writer.endElement("span");
        }
        inputText.setLocalValueSet(false);
        inputText.setStyle("display: none");
        ComponentUtils.encodeComponent((FacesContext)context, (UIComponent)inputText);
    }

    public void validateUpload(UIInput parent, FacesContext context, InputFileInfo submitted) {
        UIComponent facet = parent.getFacet(UPLOAD_BOX_FACET_NAME);
        if (!(facet instanceof HtmlInputText)) {
            return;
        }
        HtmlInputText inputText = (HtmlInputText)facet;
        Object value = inputText.getSubmittedValue();
        if (value != null && !(value instanceof String)) {
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.invalidSpecialBlob");
            parent.setValid(false);
            return;
        }
        String string = (String)value;
        if (StringUtils.isBlank((String)string)) {
            String message = context.getPartialViewContext().isAjaxRequest() ? "error.inputFile.ajax" : "error.inputFile.invalidFile";
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)message);
            parent.setValid(false);
            return;
        }
        BoxOAuth2ServiceProvider provider = (BoxOAuth2ServiceProvider)this.getBoxBlobProvider().getOAuth2Provider();
        if (provider == null) {
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.boxInvalidConfiguration");
            parent.setValid(false);
            return;
        }
        String fileId = string;
        Optional<String> serviceUserId = this.getServiceUserId(provider, fileId, FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal());
        if (!serviceUserId.isPresent()) {
            String link = String.format("<a href='#' onclick=\"openPopup('%s'); return false;\">Register a new token</a> and try again.", this.getOAuthAuthorizationUrl(provider));
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.boxInvalidPermissions", (Object[])new Object[]{link});
            parent.setValid(false);
            return;
        }
        try {
            LiveConnectFileInfo fileInfo = new LiveConnectFileInfo(serviceUserId.get(), fileId);
            SimpleManagedBlob blob = this.getBoxBlobProvider().toBlob(fileInfo);
            submitted.setBlob((Blob)blob);
            submitted.setFilename((Object)blob.getFilename());
            submitted.setMimeType((Object)blob.getMimeType());
        }
        catch (IOException e) {
            if (this.isCausedByUnauthorized(e)) {
                String link = String.format("<a href='#' onclick=\"openPopup('%s'); return false;\">Register a new token</a> and try again.", this.getOAuthAuthorizationUrl(provider));
                ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.boxInvalidPermissions", (Object[])new Object[]{link});
                parent.setValid(false);
                return;
            }
            throw new RuntimeException(e);
        }
    }

    private boolean isCausedByUnauthorized(IOException ioe) {
        return ioe.getCause() instanceof BoxAPIException && ((BoxAPIException)ioe.getCause()).getResponseCode() == 401;
    }

    public boolean isEnabled() {
        BoxOAuth2ServiceProvider provider = (BoxOAuth2ServiceProvider)this.getBoxBlobProvider().getOAuth2Provider();
        return provider != null && provider.isEnabled();
    }

    protected String getClientId(BoxOAuth2ServiceProvider provider) {
        return Optional.ofNullable(provider).map(NuxeoOAuth2ServiceProvider::getClientId).orElse("");
    }

    protected BoxBlobProvider getBoxBlobProvider() {
        return (BoxBlobProvider)((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(this.id);
    }

    private Optional<String> getServiceUserId(BoxOAuth2ServiceProvider provider, String fileId, Principal principal) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("nuxeoLogin", principal.getName());
        return provider.getCredentialDataStore().query(filter).stream().map(NuxeoOAuth2Token::new).filter(token -> this.hasAccessToFile((NuxeoOAuth2Token)token, fileId)).map(NuxeoOAuth2Token::getServiceLogin).findFirst();
    }

    private boolean hasAccessToFile(NuxeoOAuth2Token token, String fileId) {
        try {
            BoxAPIConnection client = this.getBoxBlobProvider().getBoxClient(token);
            return new BoxFile(client, fileId).getInfo(new String[]{"size"}) != null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (BoxAPIException e) {
            return e.getResponseCode() == 401;
        }
    }

    private boolean hasServiceAccount(BoxOAuth2ServiceProvider provider) {
        HttpServletRequest request = this.getHttpServletRequest();
        String username = request.getUserPrincipal().getName();
        return provider != null && provider.getServiceUser(username) != null;
    }

    private String getOAuthAuthorizationUrl(BoxOAuth2ServiceProvider provider) {
        HttpServletRequest request = this.getHttpServletRequest();
        return provider != null && provider.getClientId() != null ? provider.getAuthorizationUrl(request) : "";
    }

    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }
}

