/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.onedrive;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.util.store.DataStore;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectOAuth2ServiceProvider;
import org.nuxeo.ecm.liveconnect.onedrive.oauth.OneDriveAuthorizationCodeFlow;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveBasicAPI;
import org.nuxeo.onedrive.client.OneDriveBusinessAPI;
import org.nuxeo.onedrive.client.OneDriveEmailAccount;

public class OneDriveOAuth2ServiceProvider
extends AbstractLiveConnectOAuth2ServiceProvider {
    protected String getUserEmail(String accessToken) throws IOException {
        OneDriveAPI api = this.getAPIInitializer().apply(accessToken);
        return OneDriveEmailAccount.getCurrentUserEmailAccount((OneDriveAPI)api);
    }

    protected Optional<String> getOneDriveForBusinessResource() {
        GenericUrl tokenServerUrl = new GenericUrl(this.getTokenServerURL());
        return Optional.ofNullable((String)tokenServerUrl.getFirst("resource")).map(resource -> resource.replaceAll("\\\\/", "/"));
    }

    protected Function<String, OneDriveAPI> getAPIInitializer() {
        Optional<String> businessResourceURL = this.getOneDriveForBusinessResource();
        if (businessResourceURL.isPresent()) {
            return accessToken -> new OneDriveBusinessAPI((String)businessResourceURL.get(), accessToken);
        }
        return OneDriveBasicAPI::new;
    }

    public AuthorizationCodeFlow getAuthorizationCodeFlow() {
        String clientId = this.getClientId();
        String clientSecret = this.getClientSecret();
        String authorizationServerURL = this.getAuthorizationServerURL();
        Optional<String> businessResource = this.getOneDriveForBusinessResource();
        Credential.AccessMethod method = BearerToken.authorizationHeaderAccessMethod();
        GenericUrl tokenServerUrl = new GenericUrl(this.getTokenServerURL());
        ClientParametersAuthentication clientAuthentication = new ClientParametersAuthentication(clientId, clientSecret);
        return new OneDriveAuthorizationCodeFlow.Builder(method, HTTP_TRANSPORT, JSON_FACTORY, tokenServerUrl, (HttpExecuteInterceptor)clientAuthentication, clientId, authorizationServerURL).setBusinessResource(businessResource).setScopes(this.getScopes()).setCredentialDataStore((DataStore)this.getCredentialDataStore()).build();
    }
}

