/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.dropbox;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.oauth2.providers.AbstractOAuth2UserEmailProvider;

public class DropboxOAuth2ServiceProvider
extends AbstractOAuth2UserEmailProvider {
    protected static final Log log = LogFactory.getLog(DropboxOAuth2ServiceProvider.class);
    private static final String ACCOUNT_INFO_URL = "https://api.dropbox.com/1/account/info";
    private static final HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

        public void initialize(HttpRequest request) throws IOException {
            request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
        }
    });

    protected String getUserEmail(String accessToken) throws IOException {
        GenericUrl url = new GenericUrl(ACCOUNT_INFO_URL);
        url.set("access_token", (Object)accessToken);
        HttpResponse response = requestFactory.buildGetRequest(url).execute();
        GenericJson json = (GenericJson)response.parseAs(GenericJson.class);
        return json.get((Object)"email").toString();
    }

    public String getServiceUser(String username) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("serviceName", this.serviceName);
        filter.put("nuxeoLogin", username);
        DocumentModelList entries = this.getCredentialDataStore().query(filter);
        if (entries == null || entries.size() == 0) {
            return null;
        }
        if (entries.size() > 1) {
            log.error((Object)("Found multiple " + this.serviceName + " accounts for " + username));
        }
        return (String)((DocumentModel)entries.get(0)).getProperty("oauth2Token", "serviceLogin");
    }

    protected HttpRequestFactory getRequestFactory() {
        return requestFactory;
    }
}

