/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive.credential;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import org.nuxeo.ecm.liveconnect.google.drive.credential.CredentialFactory;

public class ServiceAccountCredentialFactory
implements CredentialFactory {
    private final String accountId;
    private final File p12File;

    public ServiceAccountCredentialFactory(String accountId, File p12File) {
        this.accountId = accountId;
        this.p12File = p12File;
    }

    @Override
    public Credential build(String user) throws IOException {
        try {
            return new GoogleCredential.Builder().setTransport(ServiceAccountCredentialFactory.getHttpTransport()).setJsonFactory(ServiceAccountCredentialFactory.getJsonFactory()).setServiceAccountId(this.accountId).setServiceAccountPrivateKeyFromP12File(this.p12File).setServiceAccountScopes(Collections.singleton("https://www.googleapis.com/auth/drive")).setServiceAccountUser(user).build();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    protected static JsonFactory getJsonFactory() {
        return JacksonFactory.getDefaultInstance();
    }

    protected static HttpTransport getHttpTransport() throws IOException {
        try {
            return GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }
}

