/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.runtime.api.Framework;

public class GoogleDriveBlobConverter
implements Converter {
    protected ConverterDescriptor descriptor;

    public void init(ConverterDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob dstBlob;
        Blob srcBlob;
        try {
            srcBlob = blobHolder.getBlob();
        }
        catch (ClientException e) {
            throw new ConversionException("Unable to fetch Blob", (Exception)((Object)e));
        }
        if (srcBlob == null) {
            return null;
        }
        try {
            dstBlob = this.convert(srcBlob);
        }
        catch (IOException e) {
            throw new ConversionException("Unable to fetch conversion", (Exception)e);
        }
        if (dstBlob == null) {
            return null;
        }
        return new SimpleCachableBlobHolder(dstBlob);
    }

    protected Blob convert(Blob blob) throws IOException {
        String mimetype = this.descriptor.getDestinationMimeType();
        InputStream is = ((BlobManager)Framework.getService(BlobManager.class)).getConvertedStream(blob, mimetype);
        return is == null ? null : Blobs.createBlob((InputStream)is, (String)mimetype);
    }
}

